/*
 * Decompiled with CFR 0.152.
 */
package me.downthepark.sethome;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import me.downthepark.sethome.SetHomeEvents;
import me.downthepark.sethome.SetHomeUtils;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SetHome
extends JavaPlugin {
    private File file = new File(this.getDataFolder(), "Homes.yml");
    YamlConfiguration homes = YamlConfiguration.loadConfiguration((File)this.file);
    private FileConfiguration config = this.getConfig();
    private static final String prefixError = ChatColor.DARK_RED + "[" + ChatColor.RED + "*" + ChatColor.DARK_RED + "] " + ChatColor.GRAY;
    private SetHomeUtils utils = new SetHomeUtils(this);

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equals("sethome")) {
            if (sender instanceof ConsoleCommandSender) {
                this.getLogger().log(Level.WARNING, "Only players can use this command.");
            } else if (sender instanceof Player) {
                Player player = (Player)sender;
                this.setPlayerHome(player);
            } else {
                sender.sendMessage(prefixError + "There was an error performing this command.");
            }
        } else if (command.getName().equals("home")) {
            if (sender instanceof ConsoleCommandSender) {
                this.getLogger().log(Level.WARNING, "Only players can use this command.");
            } else if (sender instanceof Player) {
                Player player = (Player)sender;
                if (this.utils.homeIsNull(player)) {
                    player.sendMessage(ChatColor.DARK_RED + "[" + ChatColor.RED + "*" + ChatColor.DARK_RED + "] " + ChatColor.GRAY + "You must first use /sethome");
                } else {
                    if (this.config.getBoolean("home-command-delay")) {
                        int coolDown = this.config.getInt("home-time-delay");
                        player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)("&8[&7*&8]&7 Teleporting after " + coolDown + " seconds...")));
                        try {
                            TimeUnit.SECONDS.sleep(coolDown);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    this.sendPlayerHome(player);
                }
            }
        }
        return false;
    }

    public void onEnable() {
        this.getCommand("sethome").setExecutor((CommandExecutor)this);
        this.getCommand("home").setExecutor((CommandExecutor)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SetHomeEvents(this), (Plugin)this);
        this.config.options().copyDefaults(true);
        this.saveDefaultConfig();
        try {
            this.config.save(this.getDataFolder() + File.separator + "config.yml");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.file.exists()) {
            this.saveHomesFile();
        }
    }

    public void saveHomesFile() {
        try {
            this.homes.save(this.file);
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Could not save homes file.\nHere is the stack trace:");
            e.printStackTrace();
        }
    }

    void sendPlayerHome(Player player) {
        this.utils.sendHome(player);
        if (this.config.getBoolean("play-warp-sound")) {
            player.playSound(this.utils.getHomeLocation(player), Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
        }
        String strFormatted = this.config.getString("teleport-message").replace("%player%", player.getDisplayName());
        if (this.config.getBoolean("show-teleport-message")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)strFormatted));
        }
    }

    void setPlayerHome(Player player) {
        this.utils.setHome(player);
        if (this.config.getBoolean("show-sethome-message")) {
            String strFormatted = this.config.getString("sethome-message").replace("%player%", player.getDisplayName());
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)strFormatted));
        }
    }
}

