/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic.tile;

import WayofTime.bloodmagic.core.RegistrarBloodMagicBlocks;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.entity.mob.EntityMimic;
import WayofTime.bloodmagic.tile.TileInventory;
import WayofTime.bloodmagic.util.ChatUtil;
import WayofTime.bloodmagic.util.StateUtil;
import WayofTime.bloodmagic.util.Utils;
import java.lang.reflect.Field;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class TileMimic
extends TileInventory
implements ITickable {
    private static Field _blockMetadata = ReflectionHelper.findField(TileEntity.class, (String[])new String[]{"blockMetadata", "field_145847_g"});
    public boolean dropItemsOnBreak = true;
    public NBTTagCompound tileTag = new NBTTagCompound();
    public TileEntity mimicedTile = null;
    IBlockState stateOfReplacedBlock = Blocks.field_150350_a.func_176223_P();
    public int playerCheckRadius = 5;
    public int potionSpawnRadius = 5;
    public int potionSpawnInterval = 40;
    private int internalCounter = 0;

    public TileMimic() {
        super(2, "mimic");
    }

    public void func_73660_a() {
        ItemStack potionStack;
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        ++this.internalCounter;
        if (this.internalCounter % this.potionSpawnInterval == 0 && this.func_145832_p() == 4 && !(potionStack = this.func_70301_a(1)).func_190926_b()) {
            AxisAlignedBB bb = new AxisAlignedBB(this.func_174877_v()).func_72321_a((double)this.playerCheckRadius, (double)this.playerCheckRadius, (double)this.playerCheckRadius);
            List playerList = this.func_145831_w().func_72872_a(EntityPlayer.class, bb);
            for (EntityPlayer player : playerList) {
                if (player.field_71075_bZ.field_75098_d) continue;
                double posX = (double)this.field_174879_c.func_177958_n() + 0.5 + (2.0 * this.func_145831_w().field_73012_v.nextDouble() - 1.0) * (double)this.potionSpawnRadius;
                double posY = (double)this.field_174879_c.func_177956_o() + 0.5 + (2.0 * this.func_145831_w().field_73012_v.nextDouble() - 1.0) * (double)this.potionSpawnRadius;
                double posZ = (double)this.field_174879_c.func_177952_p() + 0.5 + (2.0 * this.func_145831_w().field_73012_v.nextDouble() - 1.0) * (double)this.potionSpawnRadius;
                ItemStack newStack = new ItemStack((Item)(potionStack.func_77973_b() == RegistrarBloodMagicItems.POTION_FLASK ? Items.field_185155_bH : potionStack.func_77973_b()));
                newStack.func_77982_d(potionStack.func_77978_p());
                EntityPotion potionEntity = new EntityPotion(this.func_145831_w(), posX, posY, posZ, newStack);
                this.func_145831_w().func_72838_d((Entity)potionEntity);
                break;
            }
        }
        if (this.func_145832_p() == 4 && this.func_145831_w().func_175659_aa() != EnumDifficulty.PEACEFUL && !(this.mimicedTile instanceof IInventory)) {
            AxisAlignedBB bb = new AxisAlignedBB(this.func_174877_v()).func_72321_a((double)this.playerCheckRadius, (double)this.playerCheckRadius, (double)this.playerCheckRadius);
            List playerList = this.func_145831_w().func_72872_a(EntityPlayer.class, bb);
            for (EntityPlayer player : playerList) {
                if (player.field_71075_bZ.field_75098_d || !Utils.canEntitySeeBlock(this.func_145831_w(), (Entity)player, this.func_174877_v())) continue;
                this.spawnMimicEntity(player);
                break;
            }
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side) {
        if (!heldItem.func_190926_b() && player.field_71075_bZ.field_75098_d) {
            List list = PotionUtils.func_185189_a((ItemStack)heldItem);
            if (!list.isEmpty()) {
                if (!world.field_72995_K) {
                    this.func_70299_a(1, heldItem.func_77946_l());
                    world.func_184138_a(pos, state, state, 3);
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.bloodmagic.mimic.potionSet", new Object[0])});
                }
                return true;
            }
            if (heldItem.func_77973_b() == RegistrarBloodMagicItems.POTION_FLASK) {
                if (!world.field_72995_K) {
                    this.func_70299_a(1, ItemStack.field_190927_a);
                    world.func_184138_a(pos, state, state, 3);
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.bloodmagic.mimic.potionRemove", new Object[0])});
                }
                return true;
            }
        }
        if (this.performSpecialAbility(player, side)) {
            return true;
        }
        if (player.func_70093_af()) {
            return false;
        }
        if (!player.func_184586_b(hand).func_190926_b() && player.func_184586_b(hand).func_77973_b() == new ItemStack(RegistrarBloodMagicBlocks.MIMIC).func_77973_b()) {
            return false;
        }
        if (!this.func_70301_a(0).func_190926_b() && !player.func_184586_b(hand).func_190926_b()) {
            return false;
        }
        if (!this.dropItemsOnBreak && !player.field_71075_bZ.field_75098_d) {
            return false;
        }
        Utils.insertItemToTile(this, player, 0);
        ItemStack stack = this.func_70301_a(0);
        if (this.stateOfReplacedBlock == Blocks.field_150350_a.func_176223_P() && !stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            this.stateOfReplacedBlock = block.func_176223_P();
        }
        this.refreshTileEntity();
        if (player.field_71075_bZ.field_75098_d) {
            this.dropItemsOnBreak = this.func_70301_a(0).func_190926_b();
        }
        world.func_184138_a(pos, state, state, 3);
        return true;
    }

    public boolean performSpecialAbility(EntityPlayer player, EnumFacing sideHit) {
        switch (this.func_145832_p()) {
            case 4: {
                if (player.field_71075_bZ.field_75098_d) {
                    if (player.func_70093_af()) {
                        this.playerCheckRadius = Math.max(this.playerCheckRadius - 1, 0);
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.bloodmagic.mimic.detectRadius.down", new Object[]{this.playerCheckRadius})});
                    } else {
                        ++this.playerCheckRadius;
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.bloodmagic.mimic.detectRadius.up", new Object[]{this.playerCheckRadius})});
                    }
                    return false;
                }
                return this.spawnMimicEntity(player);
            }
        }
        if (!player.field_71075_bZ.field_75098_d) {
            return false;
        }
        if (player.func_184607_cu().func_190926_b() && !this.func_70301_a(1).func_190926_b()) {
            switch (sideHit) {
                case EAST: 
                case WEST: {
                    if (player.func_70093_af()) {
                        this.potionSpawnRadius = Math.max(this.potionSpawnRadius - 1, 0);
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.bloodmagic.mimic.potionSpawnRadius.down", new Object[]{this.potionSpawnRadius})});
                        break;
                    }
                    ++this.potionSpawnRadius;
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.bloodmagic.mimic.potionSpawnRadius.up", new Object[]{this.potionSpawnRadius})});
                    break;
                }
                case NORTH: 
                case SOUTH: {
                    if (player.func_70093_af()) {
                        this.playerCheckRadius = Math.max(this.playerCheckRadius - 1, 0);
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.bloodmagic.mimic.detectRadius.down", new Object[]{this.playerCheckRadius})});
                        break;
                    }
                    ++this.playerCheckRadius;
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.bloodmagic.mimic.detectRadius.up", new Object[]{this.playerCheckRadius})});
                    break;
                }
                case UP: 
                case DOWN: {
                    if (player.func_70093_af()) {
                        this.potionSpawnInterval = Math.max(this.potionSpawnInterval - 1, 1);
                        ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.bloodmagic.mimic.potionInterval.down", new Object[]{this.potionSpawnInterval})});
                        break;
                    }
                    ++this.potionSpawnInterval;
                    ChatUtil.sendNoSpam(player, new ITextComponent[]{new TextComponentTranslation("chat.bloodmagic.mimic.potionInterval.up", new Object[]{this.potionSpawnInterval})});
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public boolean spawnMimicEntity(EntityPlayer target) {
        if (this.func_145831_w().func_175659_aa() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        if (this.func_70301_a(0).func_190926_b() || this.func_145831_w().field_72995_K) {
            return false;
        }
        EntityMimic mimicEntity = new EntityMimic(this.func_145831_w());
        mimicEntity.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5);
        mimicEntity.initializeMimic(this.func_70301_a(0), this.tileTag, this.dropItemsOnBreak, this.stateOfReplacedBlock, this.playerCheckRadius, this.field_174879_c);
        this.tileTag = null;
        this.mimicedTile = null;
        this.func_70299_a(0, ItemStack.field_190927_a);
        this.func_145831_w().func_72838_d((Entity)mimicEntity);
        if (target != null) {
            mimicEntity.func_70624_b((EntityLivingBase)target);
        }
        this.func_145831_w().func_175698_g(this.field_174879_c);
        return true;
    }

    public void refreshTileEntity() {
        if (this.mimicedTile != null) {
            this.dropMimicedTileInventory();
        }
        this.mimicedTile = TileMimic.getTileFromStackWithTag(this.func_145831_w(), this.field_174879_c, this.func_70301_a(0), this.tileTag, this.stateOfReplacedBlock);
    }

    @Override
    public void deserialize(NBTTagCompound tag) {
        super.deserialize(tag);
        this.dropItemsOnBreak = tag.func_74767_n("dropItemsOnBreak");
        this.tileTag = tag.func_74775_l("tileTag");
        this.stateOfReplacedBlock = StateUtil.parseState(tag.func_74779_i("stateOfReplacedBlock"));
        this.mimicedTile = TileMimic.getTileFromStackWithTag(this.func_145831_w(), this.field_174879_c, this.func_70301_a(0), this.tileTag, this.stateOfReplacedBlock);
        this.playerCheckRadius = tag.func_74762_e("playerCheckRadius");
        this.potionSpawnRadius = tag.func_74762_e("potionSpawnRadius");
        this.potionSpawnInterval = Math.max(1, tag.func_74762_e("potionSpawnInterval"));
    }

    @Override
    public NBTTagCompound serialize(NBTTagCompound tag) {
        super.serialize(tag);
        tag.func_74757_a("dropItemsOnBreak", this.dropItemsOnBreak);
        tag.func_74782_a("tileTag", (NBTBase)this.tileTag);
        tag.func_74768_a("playerCheckRadius", this.playerCheckRadius);
        tag.func_74768_a("potionSpawnRadius", this.potionSpawnRadius);
        tag.func_74768_a("potionSpawnInterval", this.potionSpawnInterval);
        tag.func_74778_a("stateOfReplacedBlock", this.stateOfReplacedBlock.toString());
        return tag;
    }

    @Override
    public void dropItems() {
        if (this.dropItemsOnBreak) {
            InventoryHelper.func_180175_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (IInventory)this);
        }
        this.dropMimicedTileInventory();
    }

    public void dropMimicedTileInventory() {
        if (!this.func_145831_w().field_72995_K && this.mimicedTile instanceof IInventory) {
            InventoryHelper.func_180175_a((World)this.func_145831_w(), (BlockPos)this.func_174877_v(), (IInventory)((IInventory)this.mimicedTile));
        }
    }

    public IBlockState getReplacedState() {
        return this.stateOfReplacedBlock;
    }

    public void setReplacedState(IBlockState state) {
        this.stateOfReplacedBlock = state;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return slot == 0 && this.dropItemsOnBreak;
    }

    public static void replaceMimicWithBlockActual(TileMimic mimic) {
        World world = mimic.func_145831_w();
        BlockPos pos = mimic.func_174877_v();
        TileMimic.replaceMimicWithBlockActual(world, pos, mimic.func_70301_a(0), mimic.tileTag, mimic.stateOfReplacedBlock);
    }

    public static boolean replaceMimicWithBlockActual(World world, BlockPos pos, ItemStack stack, NBTTagCompound tileTag, IBlockState replacementState) {
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            IBlockState state = replacementState;
            if (world.func_180501_a(pos, state, 3)) {
                TileEntity tile = world.func_175625_s(pos);
                if (tile != null) {
                    tileTag.func_74768_a("x", pos.func_177958_n());
                    tileTag.func_74768_a("y", pos.func_177956_o());
                    tileTag.func_74768_a("z", pos.func_177952_p());
                    tile.func_145839_a(tileTag);
                }
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static TileEntity getTileFromStackWithTag(World world, BlockPos pos, ItemStack stack, @Nullable NBTTagCompound tag, IBlockState replacementState) {
        IBlockState state;
        Block block;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBlock && (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()).hasTileEntity(state = replacementState)) {
            TileEntity tile = block.createTileEntity(world, state);
            if (tile == null) {
                return null;
            }
            if (tag != null) {
                NBTTagCompound copyTag = tag.func_74737_b();
                copyTag.func_74768_a("x", pos.func_177958_n());
                copyTag.func_74768_a("y", pos.func_177956_o());
                copyTag.func_74768_a("z", pos.func_177952_p());
                tile.func_145839_a(copyTag);
            }
            tile.func_145834_a(world);
            try {
                _blockMetadata.setInt(tile, block.func_176201_c(replacementState));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            return tile;
        }
        return null;
    }
}

