/*
 * Decompiled with CFR 0.152.
 */
package WayofTime.bloodmagic;

import WayofTime.bloodmagic.api.BloodMagicPlugin;
import WayofTime.bloodmagic.api.IBloodMagicPlugin;
import WayofTime.bloodmagic.client.gui.GuiHandler;
import WayofTime.bloodmagic.command.CommandBloodMagic;
import WayofTime.bloodmagic.core.RegistrarBloodMagic;
import WayofTime.bloodmagic.core.RegistrarBloodMagicItems;
import WayofTime.bloodmagic.core.registry.OrbRegistry;
import WayofTime.bloodmagic.meteor.MeteorConfigHandler;
import WayofTime.bloodmagic.network.BloodMagicPacketHandler;
import WayofTime.bloodmagic.proxy.CommonProxy;
import WayofTime.bloodmagic.registry.ModArmourTrackers;
import WayofTime.bloodmagic.registry.ModCorruptionBlocks;
import WayofTime.bloodmagic.registry.ModRecipes;
import WayofTime.bloodmagic.registry.ModRituals;
import WayofTime.bloodmagic.registry.ModTranquilityHandlers;
import WayofTime.bloodmagic.ritual.RitualManager;
import WayofTime.bloodmagic.structures.ModDungeons;
import WayofTime.bloodmagic.util.PluginUtil;
import WayofTime.bloodmagic.util.handler.IMCHandler;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLModIdMappingEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import org.apache.commons.lang3.tuple.Pair;

@Mod(modid="bloodmagic", name="Blood Magic: Alchemical Wizardry", version="1.12.2-2.3.3-101", dependencies="required-after:guideapi;", guiFactory="WayofTime.bloodmagic.client.gui.GuiBloodMagicConfig$Factory", acceptedMinecraftVersions="[1.12.2]")
public class BloodMagic {
    public static final String MODID = "bloodmagic";
    public static final String NAME = "Blood Magic: Alchemical Wizardry";
    public static final String VERSION = "1.12.2-2.3.3-101";
    public static final String DEPEND = "required-after:guideapi;";
    public static final boolean IS_DEV = (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    public static final List<Pair<IBloodMagicPlugin, BloodMagicPlugin>> PLUGINS = Lists.newArrayList();
    public static final RitualManager RITUAL_MANAGER = new RitualManager(new Configuration(new File(Loader.instance().getConfigDir(), "bloodmagic/rituals.cfg")));
    public static final CreativeTabs TAB_BM = new CreativeTabs("bloodmagic.creativeTab"){

        public ItemStack func_78016_d() {
            return OrbRegistry.getOrbStack(RegistrarBloodMagic.ORB_WEAK);
        }
    };
    public static CreativeTabs TAB_TOMES = new CreativeTabs("bloodmagic.creativeTabTome"){

        public ItemStack func_78016_d() {
            return new ItemStack(RegistrarBloodMagicItems.UPGRADE_TOME);
        }

        public boolean hasSearchBar() {
            return true;
        }
    }.func_78014_h().func_78025_a("item_search.png");
    @SidedProxy(serverSide="WayofTime.bloodmagic.proxy.CommonProxy", clientSide="WayofTime.bloodmagic.proxy.ClientProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="bloodmagic")
    public static BloodMagic instance;
    private File configDir;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configDir = new File(event.getModConfigurationDirectory(), MODID);
        PLUGINS.addAll(PluginUtil.gatherPlugins(event.getAsmData()));
        PluginUtil.injectAPIInstances(PluginUtil.gatherInjections(event.getAsmData()));
        ModTranquilityHandlers.init();
        ModDungeons.init();
        RITUAL_MANAGER.discover(event.getAsmData());
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        BloodMagicPacketHandler.init();
        PluginUtil.handlePluginStep(PluginUtil.RegistrationStep.PLUGIN_REGISTER);
        ModRecipes.init();
        ModRituals.initHarvestHandlers();
        MeteorConfigHandler.init(new File(this.configDir, "meteors"));
        ModArmourTrackers.init();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        ModCorruptionBlocks.init();
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModRecipes.addCompressionHandlers();
        proxy.postInit();
    }

    @Mod.EventHandler
    public void modMapping(FMLModIdMappingEvent event) {
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandBloodMagic());
    }

    @Mod.EventHandler
    public void onIMCRecieved(FMLInterModComms.IMCEvent event) {
        IMCHandler.handleIMC(event);
    }

    static {
        FluidRegistry.enableUniversalBucket();
    }
}

