/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.yunomakegoodmap;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.lex.yunomakegoodmap.PlatformCommand;
import net.minecraftforge.lex.yunomakegoodmap.SpawnPlatformSavedData;
import net.minecraftforge.lex.yunomakegoodmap.StructureUtil;
import net.minecraftforge.lex.yunomakegoodmap.YUNoMakeGoodMap;

public class NewSpawnPlatformCommand
extends PlatformCommand {
    @Override
    public String func_71517_b() {
        return "newSpawnPlatform";
    }

    @Override
    public int func_82362_a() {
        return 2;
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "command.yunmgm.newspawn.usage";
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return NewSpawnPlatformCommand.func_175762_a((String[])args, this.getPlatforms());
        }
        if (args.length == 2) {
            return NewSpawnPlatformCommand.func_71530_a((String[])args, (String[])server.func_71213_z());
        }
        return Collections.emptyList();
    }

    private BlockPos getPositionOfPlatform(World world, int platformNumber) {
        int intRoot = (int)Math.floor(Math.sqrt(platformNumber));
        int x = (int)((double)Math.round((double)intRoot / 2.0) * Math.pow(-1.0, (double)intRoot + 1.0) + Math.pow(-1.0, (double)intRoot + 1.0) * (double)(intRoot * (intRoot + 1) - platformNumber - Math.abs(intRoot * (intRoot + 1) - platformNumber)) / 2.0);
        int z = (int)((double)Math.round((double)intRoot / 2.0) * Math.pow(-1.0, intRoot) + Math.pow(-1.0, (double)intRoot + 1.0) * (double)(intRoot * (intRoot + 1) - platformNumber + Math.abs(intRoot * (intRoot + 1) - platformNumber)) / 2.0);
        int platformDistance = YUNoMakeGoodMap.instance.getPlatformDistance(world);
        BlockPos spawnPoint = world.field_73011_w.getSpawnPoint();
        return new BlockPos(spawnPoint.func_177958_n() + x * platformDistance, world.field_73011_w.func_76557_i(), spawnPoint.func_177952_p() + z * platformDistance);
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        BlockPos spawn;
        WorldServer world;
        if (args.length != 2) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        EntityPlayerMP player = NewSpawnPlatformCommand.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[1]);
        if (player != null) {
            PlacementSettings settings = new PlacementSettings();
            world = (WorldServer)sender.func_130014_f_();
            int platformNumber = SpawnPlatformSavedData.get((World)world).addAndGetPlatformNumber();
            BlockPos pos = this.getPositionOfPlatform((World)world, platformNumber);
            Template temp = StructureUtil.loadTemplate(new ResourceLocation(args[0]), world, true);
            spawn = StructureUtil.findSpawn(temp, settings);
            spawn = spawn == null ? pos : spawn.func_177971_a((Vec3i)pos);
            sender.func_145747_a((ITextComponent)new TextComponentString("Building \"" + args[0] + "\" at " + pos.toString()));
            temp.func_189962_a((World)world, pos, settings, 2);
            world.func_175712_a(new StructureBoundingBox((Vec3i)pos, (Vec3i)pos.func_177971_a((Vec3i)temp.func_186259_a())), true);
            if (player instanceof EntityPlayerMP) {
                player.func_70634_a((double)spawn.func_177958_n() + 0.5, (double)spawn.func_177956_o() + 1.6, (double)spawn.func_177952_p() + 0.5);
            }
        } else {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        player.setSpawnChunk(spawn, true, world.field_73011_w.getDimension());
    }
}

