/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task.filter;

import com.feed_the_beast.ftbquests.quest.task.filter.ItemFilter;
import com.feed_the_beast.ftbquests.quest.task.filter.ItemFilterRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class OrFilter
extends ItemFilter {
    public final List<ItemFilter> filters = new ArrayList<ItemFilter>();

    @Override
    public NBTBase toNBT(boolean forceTagCompound) {
        if (this.filters.size() == 1 && this.filters.get(0).isValid()) {
            return this.filters.get(0).toNBT(forceTagCompound);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        for (ItemFilter filter : this.filters) {
            if (!filter.isValid()) continue;
            list.func_74742_a(filter.toNBT(true));
        }
        nbt.func_74782_a("or", (NBTBase)list);
        return nbt;
    }

    @Override
    public void fromNBT(NBTBase nbt) {
        this.filters.clear();
        if (nbt instanceof NBTTagCompound) {
            NBTTagList list = ((NBTTagCompound)nbt).func_150295_c("or", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemFilter filter = ItemFilterRegistry.createFilter((NBTBase)list.func_150305_b(i));
                if (!filter.isValid()) continue;
                this.filters.add(filter);
            }
        }
    }

    @Override
    public boolean test(ItemStack stack) {
        for (ItemFilter filter : this.filters) {
            if (!filter.isValid() || filter.test(stack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isValid() {
        for (ItemFilter filter : this.filters) {
            if (!filter.isValid()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearCache() {
        for (ItemFilter filter : this.filters) {
            filter.clearCache();
        }
    }

    @Override
    public void getAllStacks(Collection<ItemStack> stacks) {
        for (ItemFilter filter : this.filters) {
            filter.getAllStacks(stacks);
        }
    }
}

