/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task.filter;

import com.feed_the_beast.ftbquests.item.ItemMissing;
import com.feed_the_beast.ftbquests.quest.task.filter.ItemFilter;
import com.feed_the_beast.ftbquests.quest.task.filter.NBTMatchingMode;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackFilter
extends ItemFilter {
    public static final ItemStackFilter EMPTY = new ItemStackFilter(){

        @Override
        public void setIgnoreDamage(boolean v) {
        }

        @Override
        public void setNBTMode(NBTMatchingMode v) {
        }

        @Override
        public boolean test(ItemStack stack) {
            return stack.func_190926_b();
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void getAllStacks(Collection<ItemStack> stacks) {
        }
    };
    private ItemStack stack = ItemStack.field_190927_a;
    private boolean ignoreDamage = false;
    private NBTMatchingMode nbtMode = NBTMatchingMode.MATCH;
    private Item item;
    private int meta;
    private NBTTagCompound nbt;

    public void setStack(ItemStack is) {
        this.stack = is;
        this.clearCache();
    }

    public void setIgnoreDamage(boolean v) {
        this.ignoreDamage = v;
        this.clearCache();
    }

    public void setNBTMode(NBTMatchingMode v) {
        this.nbtMode = v;
        this.clearCache();
    }

    @Override
    public NBTBase toNBT(boolean forceTagCompound) {
        if (this.ignoreDamage || this.nbtMode != NBTMatchingMode.MATCH || forceTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)ItemMissing.write(this.stack, true);
            if (this.ignoreDamage) {
                nbt.func_74757_a("ignore_damage", true);
            }
            if (this.nbtMode != NBTMatchingMode.MATCH) {
                nbt.func_74774_a("ignore_nbt", (byte)this.nbtMode.ordinal());
            }
            return nbt;
        }
        return ItemMissing.write(this.stack, false);
    }

    @Override
    public void fromNBT(NBTBase n) {
        this.stack = ItemMissing.read(n);
        if (n instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)n;
            this.ignoreDamage = nbt.func_74767_n("ignore_damage");
            this.nbtMode = (NBTMatchingMode)((Object)NBTMatchingMode.NAME_MAP.get((int)nbt.func_74771_c("ignore_nbt")));
        } else {
            this.ignoreDamage = false;
            this.nbtMode = NBTMatchingMode.MATCH;
        }
    }

    @Override
    public boolean test(ItemStack is) {
        if (is == this.stack) {
            return true;
        }
        if (this.item == null) {
            this.item = this.stack.func_77973_b();
            this.meta = this.ignoreDamage ? 0 : this.stack.func_77960_j();
            NBTTagCompound nBTTagCompound = this.nbt = this.nbtMode == NBTMatchingMode.CONTAIN ? this.stack.func_77978_p() : this.item.getNBTShareTag(this.stack);
        }
        if (this.item == is.func_77973_b() && (this.ignoreDamage || this.meta == is.func_77960_j())) {
            switch (this.nbtMode) {
                case MATCH: {
                    return Objects.equals(this.nbt, is.func_77973_b().getNBTShareTag(is));
                }
                case IGNORE: {
                    return true;
                }
                case CONTAIN: {
                    NBTTagCompound nbt1 = is.func_77978_p();
                    if (nbt1 == null || nbt1.func_82582_d()) {
                        return true;
                    }
                    if (this.nbt == null || this.nbt.func_82582_d()) {
                        return false;
                    }
                    for (String s : nbt1.func_150296_c()) {
                        if (Objects.equals(this.nbt.func_74781_a(s), nbt1.func_74781_a(s))) continue;
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return !this.stack.func_190926_b();
    }

    @Override
    public void clearCache() {
        this.item = null;
        this.meta = 0;
        this.nbt = null;
    }

    @Override
    public void getAllStacks(Collection<ItemStack> stacks) {
        stacks.add(this.stack);
    }
}

