/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task.filter;

import com.feed_the_beast.ftbquests.quest.task.filter.AndFilter;
import com.feed_the_beast.ftbquests.quest.task.filter.ItemFilter;
import com.feed_the_beast.ftbquests.quest.task.filter.ItemStackFilter;
import com.feed_the_beast.ftbquests.quest.task.filter.OrFilter;
import com.feed_the_beast.ftbquests.quest.task.filter.OreNameFilter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class ItemFilterRegistry {
    private static final ArrayList<MatcherEntry> ENTRIES = new ArrayList();
    public static final List<MatcherEntry> ENTRY_LIST = Collections.unmodifiableList(ENTRIES);

    public static void register(Predicate<NBTTagCompound> predicate, Supplier<ItemFilter> supplier) {
        ENTRIES.add(new MatcherEntry(predicate, supplier));
    }

    public static ItemFilter createFilter(@Nullable NBTBase nbt) {
        if (nbt == null || nbt.func_82582_d()) {
            return new AndFilter();
        }
        if (nbt instanceof NBTTagCompound) {
            NBTTagCompound nbt1 = (NBTTagCompound)nbt;
            for (MatcherEntry entry : ENTRIES) {
                if (!entry.predicate.test(nbt1)) continue;
                ItemFilter matcher = entry.supplier.get();
                matcher.fromNBT(nbt);
                if (!matcher.isValid()) continue;
                return matcher;
            }
        }
        ItemStackFilter matcher = new ItemStackFilter();
        matcher.fromNBT(nbt);
        return matcher.isValid() ? matcher : new AndFilter();
    }

    static {
        ItemFilterRegistry.register(nbt -> nbt.func_74764_b("ore"), OreNameFilter::new);
        ItemFilterRegistry.register(nbt -> nbt.func_74764_b("and"), AndFilter::new);
        ItemFilterRegistry.register(nbt -> nbt.func_74764_b("or"), OrFilter::new);
    }

    public static class MatcherEntry {
        public final Predicate<NBTTagCompound> predicate;
        public final Supplier<ItemFilter> supplier;

        private MatcherEntry(Predicate<NBTTagCompound> p, Supplier<ItemFilter> s) {
            this.predicate = p;
            this.supplier = s;
        }
    }
}

