/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public abstract class QuestTaskData<T extends QuestTask>
implements ICapabilityProvider,
IItemHandler {
    public final T task;
    public final ITeamData teamData;
    public boolean isComplete = false;

    public QuestTaskData(T q, ITeamData d) {
        this.task = q;
        this.teamData = d;
    }

    @Nullable
    public abstract NBTBase toNBT();

    public abstract void fromNBT(@Nullable NBTBase var1);

    public abstract long getProgress();

    public abstract void resetProgress();

    public abstract void completeInstantly();

    public int getRelativeProgress() {
        long max = ((QuestTask)this.task).getMaxProgress();
        if (max <= 0L) {
            return 0;
        }
        long progress = this.getProgress();
        if (progress <= 0L) {
            return 0;
        }
        if (progress >= max) {
            return 100;
        }
        return Math.max(1, (int)((double)progress * 100.0 / (double)max));
    }

    public String getProgressString() {
        return StringUtils.formatDouble((double)this.getProgress(), (boolean)true);
    }

    public String toString() {
        return this.teamData.toString() + this.task;
    }

    public ItemStack insertItem(ItemStack stack, boolean singleItem, boolean simulate, @Nullable EntityPlayer player) {
        return stack;
    }

    public final int getSlots() {
        return 1;
    }

    public final ItemStack getStackInSlot(int slot) {
        return ItemStack.field_190927_a;
    }

    public final ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (((QuestTask)this.task).canInsertItem() && ((QuestTask)this.task).getMaxProgress() > 0L && this.getProgress() < ((QuestTask)this.task).getMaxProgress() && !stack.func_190926_b()) {
            return this.insertItem(stack, false, simulate, null);
        }
        return stack;
    }

    public final ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public final void sync() {
        this.teamData.syncTask(this);
    }

    public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
        if (!((QuestTask)this.task).canInsertItem()) {
            return false;
        }
        boolean changed = false;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack1;
            ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)(stack1 = this.insertItem(stack, false, simulate, (EntityPlayer)player)))) continue;
            changed = true;
            if (simulate) continue;
            player.field_71071_by.field_70462_a.set(i, (Object)stack1);
        }
        return changed;
    }
}

