/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.task;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.ServerUtils;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;

public class DimensionTask
extends QuestTask {
    public DimensionType dimension = DimensionType.NETHER;

    public DimensionTask(Quest quest) {
        super(quest);
    }

    @Override
    public QuestTaskType getType() {
        return FTBQuestsTasks.DIMENSION;
    }

    @Override
    public long getMaxProgress() {
        return 1L;
    }

    @Override
    public boolean hideProgressNumbers() {
        return true;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74778_a("dim", this.dimension.func_186065_b());
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        try {
            String s = nbt.func_74779_i("dim");
            this.dimension = !s.isEmpty() ? DimensionType.func_193417_a((String)s) : DimensionType.func_186069_a((int)nbt.func_74762_e("dim"));
        }
        catch (Exception ex) {
            this.dimension = DimensionType.NETHER;
        }
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.dimension.func_186068_a());
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        int dim = data.readVarInt();
        try {
            this.dimension = DimensionType.func_186069_a((int)dim);
        }
        catch (Exception ex) {
            this.dimension = DimensionType.NETHER;
        }
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("dim", () -> this.dimension, v -> {
            this.dimension = v;
        }, NameMap.create((Object)DimensionType.NETHER, (NameMap.ObjectProperties)NameMap.ObjectProperties.withName((sender, dim) -> ServerUtils.getDimensionName((int)dim.func_186068_a())), (Object[])DimensionType.values())).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.task.ftbquests.dimension", new Object[0]));
    }

    @Override
    public ITextComponent getAltDisplayName() {
        TextComponentTranslation text;
        switch (this.dimension) {
            case OVERWORLD: {
                text = new TextComponentTranslation("createWorld.customize.preset.overworld", new Object[0]);
                break;
            }
            case NETHER: {
                text = new TextComponentTranslation("advancements.nether.root.title", new Object[0]);
                break;
            }
            case THE_END: {
                text = new TextComponentTranslation("advancements.end.root.title", new Object[0]);
                break;
            }
            default: {
                text = new TextComponentString(this.dimension.func_186065_b());
            }
        }
        text.func_150256_b().func_150238_a(TextFormatting.DARK_GREEN);
        return new TextComponentTranslation("ftbquests.task.ftbquests.dimension", new Object[]{text}).func_150258_a(": ").func_150257_a((ITextComponent)text);
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<DimensionTask> {
        private Data(DimensionTask task, ITeamData data) {
            super(task, data);
        }

        @Override
        public boolean submitTask(EntityPlayerMP player, Collection<ItemStack> itemsToCheck, boolean simulate) {
            if (this.progress < 1L && player.field_71093_bK == ((DimensionTask)this.task).dimension.func_186068_a()) {
                if (!simulate) {
                    this.progress = 1L;
                    this.sync();
                }
                return true;
            }
            return false;
        }
    }
}

