/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.net.MessageDisplayRewardToast;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class XPLevelsReward
extends QuestReward {
    public int xpLevels = 1;

    public XPLevelsReward(Quest quest) {
        super(quest);
    }

    @Override
    public QuestRewardType getType() {
        return FTBQuestsRewards.XP_LEVELS;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("xp_levels", this.xpLevels);
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.xpLevels = nbt.func_74762_e("xp_levels");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeVarInt(this.xpLevels);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.xpLevels = data.readVarInt();
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("xp_levels", () -> this.xpLevels, v -> {
            this.xpLevels = v;
        }, 1, 1, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward.ftbquests.xp_levels", new Object[0]));
    }

    @Override
    public void claim(EntityPlayerMP player) {
        player.func_82242_a(this.xpLevels);
        new MessageDisplayRewardToast(this.getAltDisplayName(), this.getIcon()).sendTo(player);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        TextComponentString text = new TextComponentString("+" + this.xpLevels);
        text.func_150256_b().func_150238_a(TextFormatting.GREEN);
        return new TextComponentTranslation("ftbquests.reward.ftbquests.xp_levels", new Object[0]).func_150258_a(": ").func_150257_a((ITextComponent)text);
    }
}

