/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest.reward;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RandomReward
extends QuestReward {
    public RewardTable table;

    public RandomReward(Quest quest) {
        super(quest);
        this.table = quest.chapter.file.dummyTable;
    }

    @Override
    public QuestRewardType getType() {
        return FTBQuestsRewards.RANDOM;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.getTable().id != 0 && !this.getTable().invalid) {
            nbt.func_74768_a("table", this.quest.chapter.file.rewardTables.indexOf(this.getTable()));
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        int index;
        super.readData(nbt);
        int n = index = nbt.func_74764_b("table") ? nbt.func_74762_e("table") : -1;
        if (index >= 0 && index < this.quest.chapter.file.rewardTables.size()) {
            this.table = this.quest.chapter.file.rewardTables.get(index);
        } else {
            this.table = new RewardTable(this.quest.chapter.file);
            NBTTagList list = nbt.func_150295_c("rewards", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound nbt1 = list.func_150305_b(i);
                QuestReward reward = QuestRewardType.createReward(this.table.fakeQuest, nbt1.func_74779_i("type"));
                if (reward == null) continue;
                reward.readData(nbt1);
                this.table.rewards.add(new WeightedReward(reward, nbt1.func_74762_e("weight")));
            }
            this.table.id = this.quest.chapter.file.readID(0);
            this.table.title = this.getDisplayName().func_150260_c() + " " + this.toString();
            this.quest.chapter.file.rewardTables.add(this.table);
        }
    }

    public RewardTable getTable() {
        if (this.table == null || this.table.invalid) {
            this.table = this.quest.chapter.file.dummyTable;
        }
        return this.table;
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeInt(this.getTable().id);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.table = this.quest.chapter.file.getRewardTable(data.readInt());
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        Set<QuestObjectType> set = Collections.singleton(QuestObjectType.REWARD_TABLE);
        config.add("table", (ConfigValue)new ConfigQuestObject(this.quest.chapter.file, this.getTable(), set){

            @Override
            public void setObject(@Nullable QuestObjectBase object) {
                if (object instanceof RewardTable) {
                    RandomReward.this.table = (RewardTable)object;
                }
            }
        }, (ConfigValue)new ConfigQuestObject(this.quest.chapter.file, this.quest.chapter.file.dummyTable, set)).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.reward_table", new Object[0]));
    }

    @Override
    public void claim(EntityPlayerMP player) {
        int totalWeight = this.getTable().getTotalWeight(false);
        if (totalWeight <= 0) {
            return;
        }
        int number = player.field_70170_p.field_73012_v.nextInt(totalWeight) + 1;
        int currentWeight = 0;
        for (WeightedReward reward : this.getTable().rewards) {
            if ((currentWeight += reward.weight) < number) continue;
            reward.reward.claim(player);
            return;
        }
    }

    @Override
    public Icon getAltIcon() {
        return this.getTable().getIcon();
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return this.getTable().useTitle ? this.getTable().getDisplayName() : super.getAltDisplayName();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addMouseOverText(List<String> list) {
        this.getTable().addMouseOverText(list, true, false);
    }

    @Override
    public boolean getExcludeFromClaimAll() {
        return false;
    }
}

