/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftbquests.net.edit.MessageDeleteObjectResponse;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.util.FTBQuestsTeamData;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;

public class ServerQuestFile
extends QuestFile {
    public static ServerQuestFile INSTANCE;
    public final Universe universe;
    public final File file;
    public boolean shouldSave = false;
    private boolean isLoading = false;

    public ServerQuestFile(Universe u, File f) {
        this.universe = u;
        this.file = f;
    }

    public boolean load() {
        NBTTagCompound nbt;
        if (!this.file.exists()) {
            NBTUtils.writeNBT((File)this.file, (NBTTagCompound)new NBTTagCompound());
        }
        if ((nbt = NBTUtils.readNBT((File)this.file)) == null) {
            return false;
        }
        this.isLoading = true;
        this.readDataFull(nbt);
        this.isLoading = false;
        return true;
    }

    @Override
    public boolean isClient() {
        return false;
    }

    @Override
    public boolean isLoading() {
        return this.isLoading;
    }

    @Override
    @Nullable
    public ITeamData getData(short team) {
        if (team == 0) {
            return null;
        }
        ForgeTeam t = this.universe.getTeam(team);
        return t.isValid() ? FTBQuestsTeamData.get(t) : null;
    }

    @Override
    @Nullable
    public ITeamData getData(String team) {
        if (team.isEmpty()) {
            return null;
        }
        ForgeTeam t = this.universe.getTeam(team);
        return t.isValid() ? FTBQuestsTeamData.get(t) : null;
    }

    public Collection<FTBQuestsTeamData> getAllData() {
        Collection teams = this.universe.getTeams();
        ArrayList<FTBQuestsTeamData> list = new ArrayList<FTBQuestsTeamData>(teams.size());
        for (ForgeTeam team : teams) {
            if (!team.isValid()) continue;
            list.add(FTBQuestsTeamData.get(team));
        }
        return list;
    }

    @Override
    public void deleteObject(int id) {
        QuestObjectBase object = this.getBase(id);
        if (object != null) {
            object.deleteChildren();
            object.deleteSelf();
            this.clearCachedData();
            this.save();
        }
        new MessageDeleteObjectResponse(id).sendToAll();
    }

    public void save() {
        this.shouldSave = true;
        this.universe.markDirty();
    }

    public void saveNow() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeDataFull(nbt);
        NBTUtils.writeNBTSafe((File)this.file, (NBTTagCompound)nbt);
    }

    public void unload() {
        if (this.shouldSave) {
            this.saveNow();
            this.shouldSave = false;
        }
        this.deleteChildren();
        this.deleteSelf();
    }
}

