/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigItemStack;
import com.feed_the_beast.ftblib.lib.config.ConfigTimer;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.math.Ticks;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.item.ItemMissing;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.quest.EnumQuestShape;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.QuestVariable;
import com.feed_the_beast.ftbquests.quest.loot.EntityWeight;
import com.feed_the_beast.ftbquests.quest.loot.LootCrate;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.ItemReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.reward.QuestRewardType;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class QuestFile
extends QuestObject {
    public static final int VERSION = 3;
    public final List<QuestChapter> chapters;
    public final List<QuestVariable> variables;
    public final List<RewardTable> rewardTables;
    private final Int2ObjectOpenHashMap<QuestObjectBase> map;
    private final Object2IntOpenHashMap<String> oldMap;
    public final RewardTable dummyTable;
    public final List<ItemStack> emergencyItems;
    public Ticks emergencyItemsCooldown;
    public int fileVersion;
    public boolean defaultRewardTeam;
    public boolean defaultConsumeItems;
    public EnumQuestShape defaultShape;
    public boolean dropLootCrates;
    public final EntityWeight lootCrateNoDrop;

    public QuestFile() {
        this.id = 1;
        this.fileVersion = 0;
        this.chapters = new ArrayList<QuestChapter>();
        this.variables = new ArrayList<QuestVariable>();
        this.rewardTables = new ArrayList<RewardTable>();
        this.map = new Int2ObjectOpenHashMap();
        this.oldMap = new Object2IntOpenHashMap();
        this.dummyTable = new RewardTable(this);
        this.emergencyItems = new ArrayList<ItemStack>();
        this.emergencyItems.add(new ItemStack(Items.field_151034_e));
        this.emergencyItemsCooldown = Ticks.MINUTE.x(5L);
        this.defaultRewardTeam = false;
        this.defaultConsumeItems = false;
        this.defaultShape = EnumQuestShape.CIRCLE;
        this.dropLootCrates = false;
        this.lootCrateNoDrop = new EntityWeight();
        this.lootCrateNoDrop.passive = 4000;
        this.lootCrateNoDrop.monster = 600;
        this.lootCrateNoDrop.boss = 0;
    }

    public abstract boolean isClient();

    @Override
    public QuestFile getQuestFile() {
        return this;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.FILE;
    }

    public boolean isLoading() {
        return false;
    }

    @Override
    public long getProgress(ITeamData data) {
        long progress = 0L;
        for (QuestChapter chapter : this.chapters) {
            progress += chapter.getProgress(data);
        }
        return progress;
    }

    @Override
    public long getMaxProgress() {
        long maxProgress = 0L;
        for (QuestChapter chapter : this.chapters) {
            maxProgress += chapter.getMaxProgress();
        }
        return maxProgress;
    }

    @Override
    public int getRelativeProgress(ITeamData data) {
        int progress = 0;
        for (QuestChapter chapter : this.chapters) {
            progress += chapter.getRelativeProgress(data);
        }
        return QuestFile.fixRelativeProgress(progress, this.chapters.size());
    }

    @Override
    public boolean isComplete(ITeamData data) {
        for (QuestChapter chapter : this.chapters) {
            if (chapter.isComplete(data)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onCompleted(ITeamData data, List<EntityPlayerMP> onlineMembers) {
        super.onCompleted(data, onlineMembers);
        new ObjectCompletedEvent.FileEvent(data, this).post();
        for (EntityPlayerMP player : onlineMembers) {
            new MessageDisplayCompletionToast(this.id).sendTo(player);
        }
    }

    @Override
    public void resetProgress(ITeamData data, boolean dependencies) {
        for (QuestChapter chapter : this.chapters) {
            chapter.resetProgress(data, dependencies);
        }
    }

    @Override
    public void completeInstantly(ITeamData data, boolean dependencies) {
        for (QuestChapter chapter : this.chapters) {
            chapter.completeInstantly(data, dependencies);
        }
    }

    @Override
    public void deleteSelf() {
        this.invalid = true;
    }

    @Override
    public void deleteChildren() {
        for (QuestChapter chapter : this.chapters) {
            chapter.deleteChildren();
            chapter.invalid = true;
        }
        this.chapters.clear();
        for (QuestVariable variable : this.variables) {
            variable.deleteChildren();
            variable.invalid = true;
        }
        this.variables.clear();
        for (RewardTable table : this.rewardTables) {
            table.deleteChildren();
            table.invalid = true;
        }
        this.rewardTables.clear();
    }

    @Nullable
    public QuestObjectBase getBase(int id) {
        if (id == 0) {
            return null;
        }
        if (id == 1) {
            return this;
        }
        QuestObjectBase object = (QuestObjectBase)this.map.get(id);
        return object == null || object.invalid ? null : object;
    }

    @Nullable
    public QuestObject get(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestObject ? (QuestObject)object : null;
    }

    @Nullable
    public QuestObjectBase remove(int id) {
        QuestObjectBase object = (QuestObjectBase)this.map.remove(id);
        if (object != null) {
            if (object instanceof QuestObject) {
                QuestObject o = (QuestObject)object;
                for (QuestChapter chapter : this.chapters) {
                    for (Quest quest : chapter.quests) {
                        quest.dependencies.remove(o);
                    }
                }
            }
            object.invalid = true;
            this.refreshIDMap();
            return object;
        }
        return null;
    }

    @Nullable
    public QuestChapter getChapter(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestChapter ? (QuestChapter)object : null;
    }

    @Nullable
    public Quest getQuest(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof Quest ? (Quest)object : null;
    }

    @Nullable
    public QuestTask getTask(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestTask ? (QuestTask)object : null;
    }

    @Nullable
    public QuestVariable getVariable(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestVariable ? (QuestVariable)object : null;
    }

    @Nullable
    public QuestReward getReward(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof QuestReward ? (QuestReward)object : null;
    }

    @Nullable
    public RewardTable getRewardTable(int id) {
        QuestObjectBase object = this.getBase(id);
        return object instanceof RewardTable ? (RewardTable)object : null;
    }

    @Nullable
    public LootCrate getLootCrate(String id) {
        RewardTable table;
        if (!id.startsWith("#")) {
            for (RewardTable table2 : this.rewardTables) {
                if (table2.lootCrate == null || !table2.lootCrate.stringID.equals(id)) continue;
                return table2.lootCrate;
            }
        }
        return (table = this.getRewardTable(this.getID(id))) == null ? null : table.lootCrate;
    }

    public void refreshIDMap() {
        this.clearCachedData();
        this.map.clear();
        for (RewardTable table : this.rewardTables) {
            this.map.put(table.id, (Object)table);
        }
        for (QuestChapter chapter : this.chapters) {
            this.map.put(chapter.id, (Object)chapter);
            for (Quest quest : chapter.quests) {
                this.map.put(quest.id, (Object)quest);
                for (QuestTask task : quest.tasks) {
                    this.map.put(task.id, (Object)task);
                }
                for (QuestReward reward : quest.rewards) {
                    this.map.put(reward.id, (Object)reward);
                }
            }
        }
        for (QuestVariable variable : this.variables) {
            this.map.put(variable.id, (Object)variable);
        }
        this.clearCachedData();
    }

    public QuestObjectBase create(QuestObjectType type, int parent, NBTTagCompound extra) {
        switch (type) {
            case CHAPTER: {
                return new QuestChapter(this);
            }
            case QUEST: {
                QuestChapter chapter = this.getChapter(parent);
                if (chapter != null) {
                    return new Quest(chapter);
                }
                throw new IllegalArgumentException("Parent chapter not found!");
            }
            case TASK: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    QuestTask task = QuestTaskType.createTask(quest, extra.func_74779_i("type"));
                    if (task != null) {
                        return task;
                    }
                    throw new IllegalArgumentException("Unknown task type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case VARIABLE: {
                return new QuestVariable(this);
            }
            case REWARD: {
                Quest quest = this.getQuest(parent);
                if (quest != null) {
                    QuestReward reward = QuestRewardType.createReward(quest, extra.func_74779_i("type"));
                    if (reward != null) {
                        return reward;
                    }
                    throw new IllegalArgumentException("Unknown reward type!");
                }
                throw new IllegalArgumentException("Parent quest not found!");
            }
            case REWARD_TABLE: {
                return new RewardTable(this);
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }

    @Override
    public final void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        nbt.func_74768_a("version", 3);
        nbt.func_74757_a("default_reward_team", this.defaultRewardTeam);
        nbt.func_74757_a("default_consume", this.defaultConsumeItems);
        nbt.func_74778_a("default_quest_shape", this.defaultShape.getID());
        if (!this.emergencyItems.isEmpty()) {
            NBTTagList list = new NBTTagList();
            for (ItemStack stack : this.emergencyItems) {
                list.func_74742_a(ItemMissing.write(stack, true));
            }
            nbt.func_74782_a("emergency_items", (NBTBase)list);
        }
        nbt.func_74778_a("emergency_items_cooldown", this.emergencyItemsCooldown.toString());
        nbt.func_74757_a("drop_loot_crates", this.dropLootCrates);
        NBTTagCompound nbt1 = new NBTTagCompound();
        this.lootCrateNoDrop.writeData(nbt1);
        nbt.func_74782_a("loot_crate_no_drop", (NBTBase)nbt1);
    }

    @Override
    public final void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.defaultRewardTeam = nbt.func_74767_n("default_reward_team");
        this.defaultConsumeItems = nbt.func_74764_b("default_check_only") ? nbt.func_74767_n("default_check_only") : nbt.func_74767_n("default_consume_items");
        this.defaultShape = (EnumQuestShape)((Object)EnumQuestShape.NAME_MAP.get(nbt.func_74779_i("default_quest_shape")));
        this.emergencyItems.clear();
        NBTTagList list = nbt.func_150295_c("emergency_items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ItemStack stack = ItemMissing.read((NBTBase)list.func_150305_b(i));
            if (stack.func_190926_b()) continue;
            this.emergencyItems.add(stack);
        }
        Ticks t = Ticks.get((String)nbt.func_74779_i("emergency_items_cooldown"));
        this.emergencyItemsCooldown = t.hasTicks() ? t : Ticks.MINUTE.x(5L);
        this.dropLootCrates = nbt.func_74767_n("drop_loot_crates");
        if (nbt.func_74764_b("loot_crate_no_drop")) {
            this.lootCrateNoDrop.readData(nbt.func_74775_l("loot_crate_no_drop"));
        }
    }

    public final void writeDataFull(NBTTagCompound nbt) {
        this.writeData(nbt);
        if (!this.oldMap.isEmpty()) {
            NBTTagCompound oids = new NBTTagCompound();
            for (Object2IntMap.Entry entry : this.oldMap.object2IntEntrySet()) {
                oids.func_74768_a((String)entry.getKey(), entry.getIntValue());
            }
            nbt.func_74782_a("old_ids", (NBTBase)oids);
        }
        NBTTagList rt = new NBTTagList();
        for (RewardTable rewardTable : this.rewardTables) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            rewardTable.writeData(nbt1);
            nbt1.func_74768_a("uid", rewardTable.id);
            rt.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("reward_tables", (NBTBase)rt);
        NBTTagList c = new NBTTagList();
        for (QuestChapter chapter : this.chapters) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            chapter.writeData(nbt1);
            nbt1.func_74768_a("uid", chapter.id);
            c.func_74742_a((NBTBase)nbt1);
            if (chapter.quests.isEmpty()) continue;
            NBTTagList q = new NBTTagList();
            for (Quest quest : chapter.quests) {
                NBTTagCompound nbt3;
                IForgeRegistryEntry.Impl type;
                NBTTagCompound nbt2 = new NBTTagCompound();
                quest.writeData(nbt2);
                nbt2.func_74768_a("uid", quest.id);
                q.func_74742_a((NBTBase)nbt2);
                if (!quest.tasks.isEmpty()) {
                    NBTTagList t = new NBTTagList();
                    for (QuestTask task : quest.tasks) {
                        type = task.getType();
                        nbt3 = new NBTTagCompound();
                        task.writeData(nbt3);
                        nbt3.func_74768_a("uid", task.id);
                        if (type != FTBQuestsTasks.ITEM) {
                            nbt3.func_74778_a("type", type.getTypeForNBT());
                        }
                        t.func_74742_a((NBTBase)nbt3);
                    }
                    if (t.func_74745_c() == 1) {
                        nbt2.func_74782_a("task", t.func_179238_g(0));
                    } else if (!t.func_82582_d()) {
                        nbt2.func_74782_a("tasks", (NBTBase)t);
                    }
                }
                if (quest.rewards.isEmpty()) continue;
                NBTTagList r = new NBTTagList();
                for (QuestReward reward : quest.rewards) {
                    type = reward.getType();
                    nbt3 = new NBTTagCompound();
                    reward.writeData(nbt3);
                    nbt3.func_74768_a("uid", reward.id);
                    if (type != FTBQuestsRewards.ITEM) {
                        nbt3.func_74778_a("type", type.getTypeForNBT());
                    }
                    r.func_74742_a((NBTBase)nbt3);
                }
                if (r.func_74745_c() == 1) {
                    nbt2.func_74782_a("reward", r.func_179238_g(0));
                    continue;
                }
                if (r.func_82582_d()) continue;
                nbt2.func_74782_a("rewards", (NBTBase)r);
            }
            nbt1.func_74782_a("quests", (NBTBase)q);
        }
        nbt.func_74782_a("chapters", (NBTBase)c);
        NBTTagList nBTTagList = new NBTTagList();
        for (QuestVariable variable : this.variables) {
            NBTTagCompound nbt1 = new NBTTagCompound();
            variable.writeData(nbt1);
            nbt1.func_74768_a("uid", variable.id);
            nBTTagList.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("variables", (NBTBase)nBTTagList);
    }

    private void readIDs(QuestObjectBase object, NBTTagCompound nbt) {
        object.id = this.readID(nbt.func_74762_e("uid"));
        if (object instanceof QuestObject) {
            QuestObject o = (QuestObject)object;
            String id = nbt.func_74779_i("id").trim();
            if (!id.isEmpty() && !id.equalsIgnoreCase(object.getCodeString())) {
                String q;
                if (o instanceof QuestVariable) {
                    this.oldMap.put((Object)("#" + id), o.id);
                } else if (o instanceof QuestChapter) {
                    this.oldMap.put((Object)id, o.id);
                } else if (o instanceof Quest) {
                    String c = this.getOldID(((Quest)o).chapter);
                    if (!c.isEmpty()) {
                        this.oldMap.put((Object)(c + ":" + id), o.id);
                    }
                } else if (o instanceof QuestTask && !(q = this.getOldID(((QuestTask)o).quest)).isEmpty()) {
                    this.oldMap.put((Object)(q + ":" + id), o.id);
                }
            }
        }
    }

    public final void readDataFull(NBTTagCompound nbt) {
        int i;
        this.fileVersion = nbt.func_74762_e("version");
        this.readData(nbt);
        this.chapters.clear();
        this.variables.clear();
        this.rewardTables.clear();
        this.oldMap.clear();
        NBTTagCompound oids = nbt.func_74775_l("old_ids");
        for (String s : oids.func_150296_c()) {
            this.oldMap.put((Object)s, oids.func_74762_e(s));
        }
        NBTTagList rtl = nbt.func_150295_c("reward_tables", 10);
        for (int i2 = 0; i2 < rtl.func_74745_c(); ++i2) {
            RewardTable table = new RewardTable(this);
            NBTTagCompound nbt1 = rtl.func_150305_b(i2);
            this.readIDs(table, nbt1);
            table.readData(nbt1);
            this.rewardTables.add(table);
        }
        NBTTagList c = nbt.func_150295_c("chapters", 10);
        for (int i3 = 0; i3 < c.func_74745_c(); ++i3) {
            QuestChapter chapter = new QuestChapter(this);
            NBTTagCompound ct = c.func_150305_b(i3);
            this.readIDs(chapter, ct);
            this.chapters.add(chapter);
            NBTTagList q = ct.func_150295_c("quests", 10);
            for (int j = 0; j < q.func_74745_c(); ++j) {
                NBTBase rt;
                NBTBase tt;
                Quest quest = new Quest(chapter);
                NBTTagCompound qt = q.func_150305_b(j);
                this.readIDs(quest, qt);
                chapter.quests.add(quest);
                NBTTagList t = qt.func_150295_c("tasks", 10);
                if (t.func_82582_d() && (tt = qt.func_74781_a("task")) != null) {
                    t.func_74742_a(tt);
                }
                for (int k = 0; k < t.func_74745_c(); ++k) {
                    NBTTagCompound tt2 = t.func_150305_b(k);
                    QuestTask task = QuestTaskType.createTask(quest, tt2.func_74779_i("type"));
                    if (task == null) continue;
                    this.readIDs(task, tt2);
                    task.readData(tt2);
                    quest.tasks.add(task);
                }
                NBTTagList r = qt.func_150295_c("rewards", 10);
                if (r.func_82582_d() && (rt = qt.func_74781_a("reward")) != null) {
                    r.func_74742_a(rt);
                }
                for (int k = 0; k < r.func_74745_c(); ++k) {
                    QuestReward reward;
                    NBTTagCompound rt2 = r.func_150305_b(k);
                    if (!rt2.func_74764_b("type") && !rt2.func_74764_b("item")) {
                        reward = new ItemReward(quest);
                        ((ItemReward)reward).id = this.readID(rt2.func_74762_e("uid"));
                        ((ItemReward)reward).team = rt2.func_74767_n("team_reward");
                        rt2.func_82580_o("uid");
                        rt2.func_82580_o("team_reward");
                        ((ItemReward)reward).stack = ItemMissing.read((NBTBase)rt2);
                        quest.rewards.add(reward);
                        continue;
                    }
                    reward = QuestRewardType.createReward(quest, rt2.func_74779_i("type"));
                    if (reward == null) continue;
                    this.readIDs(reward, rt2);
                    reward.readData(rt2);
                    quest.rewards.add(reward);
                }
            }
        }
        NBTTagList v = nbt.func_150295_c("variables", 10);
        for (i = 0; i < v.func_74745_c(); ++i) {
            QuestVariable variable = new QuestVariable(this);
            NBTTagCompound nbt1 = v.func_150305_b(i);
            this.readIDs(variable, nbt1);
            variable.readData(nbt1);
            this.variables.add(variable);
        }
        this.refreshIDMap();
        for (i = 0; i < this.chapters.size(); ++i) {
            QuestChapter chapter = this.chapters.get(i);
            NBTTagCompound ct = c.func_150305_b(i);
            chapter.readData(ct);
            NBTTagList q = ct.func_150295_c("quests", 10);
            for (int j = 0; j < q.func_74745_c(); ++j) {
                Quest quest = chapter.quests.get(j);
                NBTTagCompound qt = q.func_150305_b(j);
                quest.readData(qt);
            }
        }
        for (QuestChapter chapter : this.chapters) {
            for (Quest quest : chapter.quests) {
                quest.verifyDependencies();
            }
        }
    }

    @Override
    public final void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeCollection(this.emergencyItems, DataOut.ITEM_STACK);
        data.writeVarLong(this.emergencyItemsCooldown.ticks());
        data.writeBoolean(this.defaultRewardTeam);
        data.writeBoolean(this.defaultConsumeItems);
        data.write((Object)this.defaultShape, EnumQuestShape.NAME_MAP);
        data.writeBoolean(this.dropLootCrates);
        this.lootCrateNoDrop.writeNetData(data);
    }

    @Override
    public final void readNetData(DataIn data) {
        super.readNetData(data);
        data.readCollection(this.emergencyItems, DataIn.ITEM_STACK);
        this.emergencyItemsCooldown = Ticks.get((long)data.readVarLong());
        this.defaultRewardTeam = data.readBoolean();
        this.defaultConsumeItems = data.readBoolean();
        this.defaultShape = (EnumQuestShape)((Object)data.read(EnumQuestShape.NAME_MAP));
        this.dropLootCrates = data.readBoolean();
        this.lootCrateNoDrop.readNetData(data);
    }

    public final void writeNetDataFull(DataOut data) {
        int pos = data.getPosition();
        this.writeNetData(data);
        data.writeVarInt(this.oldMap.size());
        for (Object2IntMap.Entry entry : this.oldMap.object2IntEntrySet()) {
            data.writeString((String)entry.getKey());
            data.writeInt(entry.getIntValue());
        }
        data.writeVarInt(this.rewardTables.size());
        for (RewardTable table : this.rewardTables) {
            data.writeInt(table.id);
        }
        data.writeVarInt(this.chapters.size());
        ForgeRegistry<QuestTaskType> taskTypes = QuestTaskType.getRegistry();
        ForgeRegistry<QuestRewardType> rewardTypes = QuestRewardType.getRegistry();
        for (QuestChapter chapter : this.chapters) {
            data.writeInt(chapter.id);
            data.writeVarInt(chapter.quests.size());
            for (Quest quest : chapter.quests) {
                data.writeInt(quest.id);
                data.writeVarInt(quest.tasks.size());
                for (QuestTask task : quest.tasks) {
                    data.writeVarInt(taskTypes.getID((IForgeRegistryEntry)task.getType()));
                    data.writeInt(task.id);
                }
                data.writeVarInt(quest.rewards.size());
                for (QuestReward reward : quest.rewards) {
                    data.writeVarInt(rewardTypes.getID((IForgeRegistryEntry)reward.getType()));
                    data.writeInt(reward.id);
                }
            }
        }
        data.writeVarInt(this.variables.size());
        for (QuestVariable variable : this.variables) {
            data.writeInt(variable.id);
        }
        for (RewardTable table : this.rewardTables) {
            table.writeNetData(data);
        }
        for (QuestChapter chapter : this.chapters) {
            chapter.writeNetData(data);
            for (Quest quest : chapter.quests) {
                quest.writeNetData(data);
                for (QuestTask task : quest.tasks) {
                    task.writeNetData(data);
                }
                for (QuestReward reward : quest.rewards) {
                    reward.writeNetData(data);
                }
            }
        }
        for (QuestVariable variable : this.variables) {
            variable.writeNetData(data);
        }
        if (FTBLibConfig.debugging.print_more_info) {
            FTBQuests.LOGGER.info("Wrote " + (data.getPosition() - pos) + " bytes");
        }
    }

    public final void readNetDataFull(DataIn data) {
        int pos = data.getPosition();
        this.readNetData(data);
        this.oldMap.clear();
        int oids = data.readVarInt();
        for (int i = 0; i < oids; ++i) {
            String k = data.readString();
            int v = data.readInt();
            this.oldMap.put((Object)k, v);
        }
        this.chapters.clear();
        this.variables.clear();
        this.rewardTables.clear();
        int rtl = data.readVarInt();
        for (int i = 0; i < rtl; ++i) {
            RewardTable table = new RewardTable(this);
            table.id = data.readInt();
            this.rewardTables.add(table);
        }
        ForgeRegistry<QuestTaskType> taskTypes = QuestTaskType.getRegistry();
        ForgeRegistry<QuestRewardType> rewardTypes = QuestRewardType.getRegistry();
        int c = data.readVarInt();
        for (int i = 0; i < c; ++i) {
            QuestChapter chapter = new QuestChapter(this);
            chapter.id = data.readInt();
            this.chapters.add(chapter);
            int q = data.readVarInt();
            for (int j = 0; j < q; ++j) {
                Quest quest = new Quest(chapter);
                quest.id = data.readInt();
                chapter.quests.add(quest);
                int t = data.readVarInt();
                for (int k = 0; k < t; ++k) {
                    QuestTaskType type = (QuestTaskType)taskTypes.getValue(data.readVarInt());
                    QuestTask task = type.provider.create(quest);
                    task.id = data.readInt();
                    quest.tasks.add(task);
                }
                int r = data.readVarInt();
                for (int k = 0; k < r; ++k) {
                    QuestRewardType type = (QuestRewardType)rewardTypes.getValue(data.readVarInt());
                    QuestReward reward = type.provider.create(quest);
                    reward.id = data.readInt();
                    quest.rewards.add(reward);
                }
            }
        }
        int v = data.readVarInt();
        for (int i = 0; i < v; ++i) {
            QuestVariable variable = new QuestVariable(this);
            variable.id = data.readInt();
            this.variables.add(variable);
        }
        this.refreshIDMap();
        for (RewardTable table : this.rewardTables) {
            table.readNetData(data);
        }
        for (QuestChapter chapter : this.chapters) {
            chapter.readNetData(data);
            for (Quest quest : chapter.quests) {
                quest.readNetData(data);
                for (QuestTask task : quest.tasks) {
                    task.readNetData(data);
                }
                for (QuestReward reward : quest.rewards) {
                    reward.readNetData(data);
                }
            }
        }
        for (QuestVariable variable : this.variables) {
            variable.readNetData(data);
        }
        if (FTBLibConfig.debugging.print_more_info) {
            FTBQuests.LOGGER.info("Read " + (data.getPosition() - pos) + " bytes");
        }
    }

    @Nullable
    public abstract ITeamData getData(short var1);

    @Nullable
    public abstract ITeamData getData(String var1);

    public abstract Collection<? extends ITeamData> getAllData();

    public abstract void deleteObject(int var1);

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (QuestChapter chapter : this.chapters) {
            list.add(chapter.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return new TextComponentTranslation("ftbquests.file", new Object[0]);
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addList("emergency_items", this.emergencyItems, (ConfigValue)new ConfigItemStack(ItemStack.field_190927_a), ConfigItemStack::new, ConfigItemStack::getStack);
        config.add("emergency_items_cooldown", (ConfigValue)new ConfigTimer(Ticks.NO_TICKS){

            public Ticks getTimer() {
                return QuestFile.this.emergencyItemsCooldown;
            }

            public void setTimer(Ticks t) {
                QuestFile.this.emergencyItemsCooldown = t;
            }
        }, (ConfigValue)new ConfigTimer(Ticks.MINUTE.x(5L)));
        config.addBool("drop_loot_crates", () -> this.dropLootCrates, v -> {
            this.dropLootCrates = v;
        }, false);
        ConfigGroup defaultsGroup = config.getGroup("defaults");
        defaultsGroup.addBool("reward_team", () -> this.defaultRewardTeam, v -> {
            this.defaultRewardTeam = v;
        }, false);
        defaultsGroup.addBool("consume_items", () -> this.defaultConsumeItems, v -> {
            this.defaultConsumeItems = v;
        }, false);
        defaultsGroup.addEnum("quest_shape", () -> this.defaultShape, v -> {
            this.defaultShape = v;
        }, EnumQuestShape.NAME_MAP);
        ConfigGroup d = config.getGroup("loot_crate_no_drop");
        d.addInt("passive", () -> this.lootCrateNoDrop.passive, v -> {
            this.lootCrateNoDrop.passive = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.loot.entitytype.passive", new Object[0]));
        d.addInt("monster", () -> this.lootCrateNoDrop.monster, v -> {
            this.lootCrateNoDrop.monster = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.loot.entitytype.monster", new Object[0]));
        d.addInt("boss", () -> this.lootCrateNoDrop.boss, v -> {
            this.lootCrateNoDrop.boss = v;
        }, 0, 0, Integer.MAX_VALUE).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.loot.entitytype.boss", new Object[0]));
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (QuestChapter chapter : this.chapters) {
            chapter.clearCachedData();
        }
    }

    public int readID(int id) {
        while (id == 0 || id == 1 || this.map.get(id) != null) {
            id = MathUtils.RAND.nextInt();
        }
        return id;
    }

    public int getID(String id) {
        if (id.isEmpty()) {
            return 0;
        }
        if (id.charAt(0) == '*') {
            return 1;
        }
        try {
            return Long.valueOf(id.charAt(0) == '#' ? id.substring(1) : id, 16).intValue();
        }
        catch (Exception ex) {
            return this.oldMap.getInt((Object)id);
        }
    }

    public int getID(@Nullable NBTBase nbt) {
        if (nbt == null || nbt.func_82582_d()) {
            return 0;
        }
        if (nbt instanceof NBTTagString) {
            return this.getID(((NBTTagString)nbt).func_150285_a_());
        }
        if (nbt instanceof NBTPrimitive) {
            return ((NBTPrimitive)nbt).func_150287_d();
        }
        return 0;
    }

    public String getOldID(QuestObject object) {
        for (Object2IntMap.Entry entry : this.oldMap.object2IntEntrySet()) {
            if (entry.getIntValue() != object.id) continue;
            return (String)entry.getKey();
        }
        return "";
    }

    @Nullable
    public LootCrate getRandomLootCrate(Entity entity, Random random) {
        int totalWeight = this.lootCrateNoDrop.getWeight(entity);
        for (RewardTable table : this.rewardTables) {
            if (table.lootCrate == null) continue;
            totalWeight += table.lootCrate.drops.getWeight(entity);
        }
        if (totalWeight <= 0) {
            return null;
        }
        int number = random.nextInt(totalWeight) + 1;
        int currentWeight = this.lootCrateNoDrop.getWeight(entity);
        if (currentWeight < number) {
            for (RewardTable table : this.rewardTables) {
                if (table.lootCrate == null || (currentWeight += table.lootCrate.drops.getWeight(entity)) < number) continue;
                return table.lootCrate;
            }
        }
        return null;
    }
}

