/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.quest;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.ConfigString;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.icon.IconAnimation;
import com.feed_the_beast.ftblib.lib.io.Bits;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.ListUtils;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.events.ObjectCompletedEvent;
import com.feed_the_beast.ftbquests.gui.tree.GuiQuestTree;
import com.feed_the_beast.ftbquests.net.MessageDisplayCompletionToast;
import com.feed_the_beast.ftbquests.quest.EnumQuestShape;
import com.feed_the_beast.ftbquests.quest.EnumQuestVisibilityType;
import com.feed_the_beast.ftbquests.quest.EnumVisibility;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.QuestObject;
import com.feed_the_beast.ftbquests.quest.QuestObjectBase;
import com.feed_the_beast.ftbquests.quest.QuestObjectType;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.QuestReward;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class Quest
extends QuestObject {
    public static final int POS_LIMIT = 25;
    private static final List<QuestObjectType> DEP_TYPES = Arrays.asList(QuestObjectType.QUEST, QuestObjectType.CHAPTER, QuestObjectType.VARIABLE);
    public final QuestChapter chapter;
    public String description;
    public EnumQuestVisibilityType visibilityType;
    public byte x;
    public byte y;
    public EnumQuestShape shape;
    public final List<String> text;
    public final Set<QuestObject> dependencies;
    public boolean canRepeat;
    public final List<QuestTask> tasks;
    public final List<QuestReward> rewards;
    public boolean tasksIgnoreDependencies;

    public Quest(QuestChapter c) {
        this.chapter = c;
        this.description = "";
        this.visibilityType = EnumQuestVisibilityType.NORMAL;
        this.x = 0;
        this.y = 0;
        this.shape = this.chapter.file.defaultShape;
        this.text = new ArrayList<String>();
        this.canRepeat = false;
        this.dependencies = new HashSet<QuestObject>();
        this.tasks = new ArrayList<QuestTask>();
        this.rewards = new ArrayList<QuestReward>();
        this.tasksIgnoreDependencies = false;
    }

    @Override
    public QuestObjectType getObjectType() {
        return QuestObjectType.QUEST;
    }

    @Override
    public QuestFile getQuestFile() {
        return this.chapter.file;
    }

    @Override
    public QuestChapter getQuestChapter() {
        return this.chapter;
    }

    @Override
    public int getParentID() {
        return this.chapter.id;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.visibilityType != EnumQuestVisibilityType.NORMAL) {
            nbt.func_74778_a("type", this.visibilityType.func_176610_l());
        }
        if (this.x != 0) {
            nbt.func_74774_a("x", this.x);
        }
        if (this.y != 0) {
            nbt.func_74774_a("y", this.y);
        }
        if (this.shape != this.chapter.file.defaultShape) {
            nbt.func_74778_a("shape", this.shape.getID());
        }
        if (!this.description.isEmpty()) {
            nbt.func_74778_a("description", this.description);
        }
        if (!this.text.isEmpty()) {
            NBTTagList array = new NBTTagList();
            for (String value : this.text) {
                array.func_74742_a((NBTBase)new NBTTagString(value));
            }
            nbt.func_74782_a("text", (NBTBase)array);
        }
        if (this.canRepeat) {
            nbt.func_74757_a("can_repeat", true);
        }
        if (this.tasksIgnoreDependencies) {
            nbt.func_74757_a("tasks_ignore_deps", true);
        }
        this.dependencies.removeIf(QuestObjectBase.PREDICATE_INVALID);
        if (!this.dependencies.isEmpty()) {
            if (this.dependencies.size() == 1) {
                nbt.func_74768_a("dependency", this.dependencies.iterator().next().id);
            } else {
                int[] ai = new int[this.dependencies.size()];
                int i = 0;
                for (QuestObject object : this.dependencies) {
                    ai[i] = object.id;
                    ++i;
                }
                nbt.func_74783_a("dependencies", ai);
            }
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.description = nbt.func_74779_i("description");
        this.visibilityType = (EnumQuestVisibilityType)((Object)EnumQuestVisibilityType.NAME_MAP.get(nbt.func_74779_i("visibility")));
        this.x = (byte)MathHelper.func_76125_a((int)nbt.func_74771_c("x"), (int)-25, (int)25);
        this.y = (byte)MathHelper.func_76125_a((int)nbt.func_74771_c("y"), (int)-25, (int)25);
        this.shape = nbt.func_74764_b("shape") ? (EnumQuestShape)((Object)EnumQuestShape.NAME_MAP.get(nbt.func_74779_i("shape"))) : this.chapter.file.defaultShape;
        this.text.clear();
        NBTTagList list = nbt.func_150295_c("text", 8);
        for (int k = 0; k < list.func_74745_c(); ++k) {
            this.text.add(list.func_150307_f(k));
        }
        this.canRepeat = nbt.func_74767_n("can_repeat");
        this.tasksIgnoreDependencies = nbt.func_74767_n("tasks_ignore_deps");
        this.dependencies.clear();
        NBTBase deps = nbt.func_74781_a("dependencies");
        if (deps == null) {
            deps = nbt.func_74781_a("dependency");
        }
        if (deps instanceof NBTTagList) {
            list = (NBTTagList)deps;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                QuestObject o = this.chapter.file.get(this.chapter.file.getID(list.func_179238_g(i)));
                if (o == null) continue;
                this.dependencies.add(o);
            }
        } else if (deps instanceof NBTTagIntArray) {
            for (int i : ((NBTTagIntArray)deps).func_150302_c()) {
                QuestObject o = this.chapter.file.get(i);
                if (o == null) continue;
                this.dependencies.add(o);
            }
        } else {
            QuestObject o = this.chapter.file.get(this.chapter.file.getID(deps));
            if (o != null) {
                this.dependencies.add(o);
            }
        }
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeString(this.description);
        data.write((Object)this.visibilityType, EnumQuestVisibilityType.NAME_MAP);
        data.writeByte((int)this.x);
        data.writeByte((int)this.y);
        data.write((Object)this.shape, EnumQuestShape.NAME_MAP);
        data.writeCollection(this.text, DataOut.STRING);
        int flags = 0;
        flags = Bits.setFlag((int)flags, (int)1, (boolean)this.canRepeat);
        flags = Bits.setFlag((int)flags, (int)2, (boolean)this.tasksIgnoreDependencies);
        data.writeVarInt(flags);
        data.writeVarInt(this.dependencies.size());
        for (QuestObject d : this.dependencies) {
            if (d == null || d.invalid) {
                data.writeInt(0);
                continue;
            }
            data.writeInt(d.id);
        }
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.description = data.readString();
        this.visibilityType = (EnumQuestVisibilityType)((Object)data.read(EnumQuestVisibilityType.NAME_MAP));
        this.x = data.readByte();
        this.y = data.readByte();
        this.shape = (EnumQuestShape)((Object)data.read(EnumQuestShape.NAME_MAP));
        data.readCollection(this.text, DataIn.STRING);
        int flags = data.readVarInt();
        this.canRepeat = Bits.getFlag((int)flags, (int)1);
        this.tasksIgnoreDependencies = Bits.getFlag((int)flags, (int)2);
        int d = data.readVarInt();
        for (int i = 0; i < d; ++i) {
            QuestObject object = this.chapter.file.get(data.readInt());
            if (object == null) continue;
            this.dependencies.add(object);
        }
    }

    @Override
    public long getProgress(ITeamData data) {
        long progress = 0L;
        for (QuestTask task : this.tasks) {
            if (task.invalid) continue;
            progress += task.getProgress(data);
        }
        return progress;
    }

    @Override
    public long getMaxProgress() {
        long maxProgress = 0L;
        for (QuestTask task : this.tasks) {
            if (task.invalid) continue;
            maxProgress += task.getMaxProgress();
        }
        return maxProgress;
    }

    @Override
    public int getRelativeProgress(ITeamData data) {
        int progress = 0;
        int s = 0;
        for (QuestTask task : this.tasks) {
            if (task.invalid) continue;
            progress += task.getRelativeProgress(data);
            ++s;
        }
        return Quest.fixRelativeProgress(progress, s);
    }

    @Override
    public boolean isComplete(ITeamData data) {
        for (QuestTask task : this.tasks) {
            if (task.invalid || task.isComplete(data)) continue;
            return false;
        }
        for (QuestObject object : this.dependencies) {
            if (object.isComplete(data)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onCompleted(ITeamData data, List<EntityPlayerMP> onlineMembers) {
        super.onCompleted(data, onlineMembers);
        new ObjectCompletedEvent.QuestEvent(data, this).post();
        for (EntityPlayerMP player : onlineMembers) {
            new MessageDisplayCompletionToast(this.id).sendTo(player);
        }
        if (this.chapter.isComplete(data)) {
            this.chapter.onCompleted(data, onlineMembers);
        }
    }

    @Override
    public void resetProgress(ITeamData data, boolean deps) {
        if (deps) {
            for (QuestObject dep : this.dependencies) {
                if (dep.invalid) continue;
                dep.resetProgress(data, true);
            }
        }
        for (QuestTask task : this.tasks) {
            task.resetProgress(data, deps);
        }
        data.unclaimRewards(this.rewards);
    }

    @Override
    public void completeInstantly(ITeamData data, boolean deps) {
        if (deps) {
            for (QuestObject dep : this.dependencies) {
                if (dep.invalid) continue;
                dep.completeInstantly(data, true);
            }
        }
        for (QuestTask task : this.tasks) {
            task.completeInstantly(data, deps);
        }
    }

    public boolean canStartTasks(ITeamData data) {
        if (!this.tasksIgnoreDependencies) {
            for (QuestObject object : this.dependencies) {
                if (object.isComplete(data)) continue;
                return false;
            }
        }
        return this.getVisibility(data).isVisible();
    }

    @Override
    public Icon getAltIcon() {
        ArrayList<Icon> list = new ArrayList<Icon>();
        for (QuestTask task : this.tasks) {
            list.add(task.getIcon());
        }
        return IconAnimation.fromList(list, (boolean)false);
    }

    @Override
    public ITextComponent getAltDisplayName() {
        Iterator<QuestTask> iterator = this.tasks.iterator();
        if (iterator.hasNext()) {
            QuestTask task = iterator.next();
            return task.getDisplayName().func_150259_f();
        }
        return new TextComponentTranslation("ftbquests.unnamed", new Object[0]);
    }

    @Override
    public void deleteSelf() {
        super.deleteSelf();
        this.chapter.quests.remove(this);
    }

    @Override
    public void deleteChildren() {
        for (QuestTask task : this.tasks) {
            task.deleteChildren();
            task.invalid = true;
        }
        for (QuestReward reward : this.rewards) {
            reward.deleteChildren();
            reward.invalid = true;
        }
        this.tasks.clear();
        this.rewards.clear();
    }

    @Override
    public void onCreated() {
        this.chapter.quests.add(this);
        if (!this.tasks.isEmpty()) {
            for (QuestTask task : ListUtils.clearAndCopy(this.tasks)) {
                task.onCreated();
            }
        }
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("x", () -> this.x, v -> {
            this.x = (byte)v;
        }, 0, -25, 25);
        config.addInt("y", () -> this.y, v -> {
            this.y = (byte)v;
        }, 0, -25, 25);
        config.addEnum("shape", () -> this.shape, v -> {
            this.shape = v;
        }, EnumQuestShape.NAME_MAP);
        config.addString("description", () -> this.description, v -> {
            this.description = v;
        }, "");
        config.addList("text", this.text, (ConfigValue)new ConfigString(""), ConfigString::new, ConfigString::getString);
        config.addList("dependencies", this.dependencies, (ConfigValue)new ConfigQuestObject(this.chapter.file, null, DEP_TYPES), v -> new ConfigQuestObject(this.chapter.file, (QuestObjectBase)v, (Collection<QuestObjectType>)DEP_TYPES), c -> (QuestObject)c.getObject()).setDisplayName((ITextComponent)new TextComponentTranslation("ftbquests.dependencies", new Object[0]));
        config.addBool("can_repeat", () -> this.canRepeat, v -> {
            this.canRepeat = v;
        }, false);
        config.addBool("tasks_ignore_dependencies", () -> this.tasksIgnoreDependencies, v -> {
            this.tasksIgnoreDependencies = v;
        }, false);
    }

    public EnumVisibility getVisibility(@Nullable ITeamData data) {
        EnumVisibility v = EnumVisibility.VISIBLE;
        for (QuestObject object : this.dependencies) {
            if (!(object instanceof Quest) || !(v = v.weakest(((Quest)object).getVisibility(data))).isInvisible()) continue;
            return EnumVisibility.INVISIBLE;
        }
        if (data == null && this.visibilityType != EnumQuestVisibilityType.NORMAL) {
            return this.visibilityType == EnumQuestVisibilityType.SECRET_ONE || this.visibilityType == EnumQuestVisibilityType.SECRET_ALL ? EnumVisibility.SECRET : EnumVisibility.INVISIBLE;
        }
        return v;
    }

    public QuestTask getTask(int index) {
        if (this.tasks.isEmpty()) {
            throw new IllegalStateException("Quest has no tasks!");
        }
        if (index <= 0) {
            return this.tasks.get(0);
        }
        if (index >= this.tasks.size()) {
            return this.tasks.get(this.tasks.size() - 1);
        }
        return this.tasks.get(index);
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        for (QuestTask task : this.tasks) {
            task.clearCachedData();
        }
        for (QuestReward reward : this.rewards) {
            reward.clearCachedData();
        }
    }

    public boolean hasDependency(QuestObject object) {
        return !object.invalid && this.dependencies.contains(object);
    }

    public boolean verifyDependencies() {
        this.dependencies.removeIf(QuestObjectBase.PREDICATE_INVALID);
        if (this.dependencies.isEmpty()) {
            return true;
        }
        if (this.verifyDependenciesInternal(this, true)) {
            return true;
        }
        this.dependencies.clear();
        if (!this.chapter.file.isClient()) {
            ServerQuestFile.INSTANCE.save();
        }
        return false;
    }

    private boolean verifyDependenciesInternal(Quest original, boolean firstLoop) {
        if (this == original && !firstLoop) {
            return false;
        }
        for (QuestObject object : this.dependencies) {
            if (!(object instanceof Quest) || ((Quest)object).verifyDependenciesInternal(original, false)) continue;
            return false;
        }
        return true;
    }

    public void checkRepeatableQuests(ITeamData data, UUID player) {
        if (!this.canRepeat) {
            return;
        }
        for (QuestReward reward1 : this.rewards) {
            if (data.isRewardClaimed(player, reward1)) continue;
            return;
        }
        this.resetProgress(data, false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void editedFromGUI() {
        GuiQuestTree gui = (GuiQuestTree)((Object)ClientUtils.getCurrentGuiAs(GuiQuestTree.class));
        if (gui != null) {
            gui.quests.refreshWidgets();
            gui.questLeft.refreshWidgets();
            gui.questRight.refreshWidgets();
        }
        if (this.chapter.quests.size() == 1) {
            ClientQuestFile.INSTANCE.questTreeGui.resetScroll(true);
        }
    }
}

