/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.ic2;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.integration.ic2.TileTaskScreenCoreIC2;
import com.feed_the_beast.ftbquests.integration.ic2.TileTaskScreenPartIC2;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.EnergyTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenCore;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenPart;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class IC2EnergyTask
extends EnergyTask {
    public static final ResourceLocation EMPTY_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/ic2_empty.png");
    public static final ResourceLocation FULL_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/ic2_full.png");

    public IC2EnergyTask(Quest quest) {
        super(quest);
    }

    @Override
    public QuestTaskType getType() {
        return FTBQuestsTasks.IC2_ENERGY;
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return new TextComponentTranslation("ftbquests.task.ftbquests.ic2_energy.text", new Object[]{StringUtils.formatDouble((double)this.value, (boolean)true)});
    }

    @Override
    public Class<? extends TileTaskScreenCore> getScreenCoreClass() {
        return TileTaskScreenCoreIC2.class;
    }

    @Override
    public Class<? extends TileTaskScreenPart> getScreenPartClass() {
        return TileTaskScreenPartIC2.class;
    }

    @Override
    public TileTaskScreenCore createScreenCore(World world) {
        return new TileTaskScreenCoreIC2();
    }

    @Override
    public TileTaskScreenPart createScreenPart(World world) {
        return new TileTaskScreenPartIC2();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawGUI(@Nullable QuestTaskData data, int x, int y, int w, int h) {
        double r;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        double d = r = data == null ? 0.0 : (double)data.getProgress() / (double)((QuestTask)data.task).getMaxProgress();
        if (r > 0.0) {
            double y1 = (double)y + (0.09375 + (1.0 - r) * 26.0 / 32.0) * (double)h;
            double h1 = r * 26.0 / 32.0 * (double)h;
            double v0 = 0.09375 + 0.8125 * (1.0 - r);
            double v1 = 0.90625;
            ClientUtils.MC.func_110434_K().func_110577_a(FULL_TEXTURE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)x, y1 + h1, 0.0).func_187315_a(0.0, v1).func_181675_d();
            buffer.func_181662_b((double)(x + w), y1 + h1, 0.0).func_187315_a(1.0, v1).func_181675_d();
            buffer.func_181662_b((double)(x + w), y1, 0.0).func_187315_a(1.0, v0).func_181675_d();
            buffer.func_181662_b((double)x, y1, 0.0).func_187315_a(0.0, v0).func_181675_d();
            tessellator.func_78381_a();
        }
        ClientUtils.MC.func_110434_K().func_110577_a(EMPTY_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawScreen(@Nullable QuestTaskData data) {
        double r;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        ClientUtils.MC.func_110434_K().func_110577_a(EMPTY_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double x = -0.5;
        double y = -0.5;
        double w = 1.0;
        double h = 1.0;
        double z = 0.0;
        buffer.func_181662_b(x, y + h, z).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y + h, z).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y, z).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x, y, z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        double d = r = data == null ? 0.0 : (double)data.getProgress() / (double)((QuestTask)data.task).getMaxProgress();
        if (r > 0.0) {
            x -= 0.0078125;
            w += 0.015625;
            y = 0.09375 + (1.0 - r) * 26.0 / 32.0 - 0.5;
            h = r * 26.0 / 32.0;
            y -= 0.0078125;
            h += 0.015625;
            z = 0.003;
            double u0 = 0.0;
            double v0 = 0.09375 + 0.8125 * (1.0 - r);
            double u1 = 1.0;
            double v1 = 0.90625;
            ClientUtils.MC.func_110434_K().func_110577_a(FULL_TEXTURE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(x, y + h, z).func_187315_a(u0, v1).func_181675_d();
            buffer.func_181662_b(x + w, y + h, z).func_187315_a(u1, v1).func_181675_d();
            buffer.func_181662_b(x + w, y, z).func_187315_a(u1, v0).func_181675_d();
            buffer.func_181662_b(x, y, z).func_187315_a(u0, v0).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<IC2EnergyTask> {
        private Data(IC2EnergyTask task, ITeamData data) {
            super(task, data);
        }

        public double injectEnergy(double amount) {
            if (amount > 0.0 && this.progress < ((IC2EnergyTask)this.task).value) {
                double add = Math.min(amount, (double)(((IC2EnergyTask)this.task).value - this.progress));
                if (((IC2EnergyTask)this.task).maxInput > 0L) {
                    add = Math.min(add, (double)((IC2EnergyTask)this.task).maxInput);
                }
                if (add > 0.0) {
                    this.progress = (long)((double)this.progress + add);
                    this.sync();
                    return amount - add;
                }
            }
            return amount;
        }
    }
}

