/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.forestry;

import com.feed_the_beast.ftbquests.item.ItemMissing;
import com.feed_the_beast.ftbquests.quest.task.filter.ItemFilter;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.ISpeciesType;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class BeeItemFilter
extends ItemFilter {
    private ItemStack beeStack = ItemStack.field_190927_a;
    private boolean checkSecondary = false;
    private EnumBeeType beeType = null;
    private String primary = null;
    private String secondary = null;

    @Override
    public NBTBase toNBT(boolean forceTagCompound) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("bee", ItemMissing.write(this.beeStack, false));
        if (this.checkSecondary) {
            nbt.func_74757_a("check_secondary", true);
        }
        return nbt;
    }

    @Override
    public void fromNBT(NBTBase n) {
        if (n instanceof NBTTagCompound) {
            NBTTagCompound nbt = (NBTTagCompound)n;
            this.beeStack = ItemMissing.read(nbt.func_74781_a("bee"));
            this.checkSecondary = nbt.func_74767_n("check_secondary");
        }
    }

    public void setBee(ItemStack stack) {
        if (BeeManager.beeRoot != null && BeeManager.beeRoot.getType(stack) != null) {
            this.beeStack = stack.func_77946_l();
            this.clearCache();
        }
    }

    @Override
    public boolean test(ItemStack stack) {
        if (BeeManager.beeRoot == null) {
            return false;
        }
        if (this.beeType == null) {
            this.beeType = BeeManager.beeRoot.getType(this.beeStack);
            if (this.beeType == null) {
                return false;
            }
            IBee bee = BeeManager.beeRoot.getMember(this.beeStack);
            this.primary = bee.getGenome().getPrimary().getUID();
            this.secondary = bee.getGenome().getSecondary().getUID();
        } else if (BeeManager.beeRoot.isMember(stack, (ISpeciesType)this.beeType)) {
            IBee b = BeeManager.beeRoot.getMember(stack);
            return b != null && (!this.checkSecondary || b.getGenome().getSecondary().getUID().equals(this.secondary)) && b.getGenome().getPrimary().getUID().equals(this.primary);
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return false;
    }

    @Override
    public void clearCache() {
        this.beeType = null;
        this.primary = null;
        this.secondary = null;
    }

    @Override
    public void getAllStacks(Collection<ItemStack> stacks) {
        stacks.add(this.beeStack);
    }
}

