/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.integration.botania;

import com.feed_the_beast.ftblib.lib.client.ClientUtils;
import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.util.StringUtils;
import com.feed_the_beast.ftbquests.integration.botania.TileTaskScreenCoreBotania;
import com.feed_the_beast.ftbquests.integration.botania.TileTaskScreenPartBotania;
import com.feed_the_beast.ftbquests.quest.ITeamData;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.task.EnergyTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.QuestTask;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskData;
import com.feed_the_beast.ftbquests.quest.task.QuestTaskType;
import com.feed_the_beast.ftbquests.quest.task.SimpleQuestTaskData;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenCore;
import com.feed_the_beast.ftbquests.tile.TileTaskScreenPart;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.botania.api.mana.IManaReceiver;

public class ManaTask
extends EnergyTask {
    public static final ResourceLocation EMPTY_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/botania_mana_empty.png");
    public static final ResourceLocation FULL_TEXTURE = new ResourceLocation("ftbquests", "textures/tasks/botania_mana_full.png");
    public boolean showNumbers;

    public ManaTask(Quest quest) {
        super(quest);
    }

    @Override
    public QuestTaskType getType() {
        return FTBQuestsTasks.BOTANIA_MANA;
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        super.writeData(nbt);
        if (this.showNumbers) {
            nbt.func_74757_a("show_numbers", true);
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        super.readData(nbt);
        this.showNumbers = nbt.func_74767_n("show_numbers");
    }

    @Override
    public void writeNetData(DataOut data) {
        super.writeNetData(data);
        data.writeBoolean(this.showNumbers);
    }

    @Override
    public void readNetData(DataIn data) {
        super.readNetData(data);
        this.showNumbers = data.readBoolean();
    }

    @Override
    public ITextComponent getAltDisplayName() {
        return this.showNumbers ? new TextComponentTranslation("ftbquests.task.ftbquests.botania_mana.text", new Object[]{StringUtils.formatDouble((double)this.value, (boolean)true)}) : new TextComponentTranslation("ftbquests.task.ftbquests.botania_mana.value", new Object[0]);
    }

    @Override
    public Class<? extends TileTaskScreenCore> getScreenCoreClass() {
        return TileTaskScreenCoreBotania.class;
    }

    @Override
    public Class<? extends TileTaskScreenPart> getScreenPartClass() {
        return TileTaskScreenPartBotania.class;
    }

    @Override
    public TileTaskScreenCore createScreenCore(World world) {
        return new TileTaskScreenCoreBotania();
    }

    @Override
    public TileTaskScreenPart createScreenPart(World world) {
        return new TileTaskScreenPartBotania();
    }

    @Override
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addBool("show_numbers", () -> this.showNumbers, v -> {
            this.showNumbers = v;
        }, false);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawGUI(@Nullable QuestTaskData data, int x, int y, int w, int h) {
        double r;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        double d = r = data == null ? 0.0 : (double)data.getProgress() / (double)((QuestTask)data.task).getMaxProgress();
        if (r > 0.0) {
            double y1 = (double)y + (0.09375 + (1.0 - r) * 26.0 / 32.0) * (double)h;
            double h1 = r * 26.0 / 32.0 * (double)h;
            double v0 = 0.09375 + 0.8125 * (1.0 - r);
            double v1 = 0.90625;
            ClientUtils.MC.func_110434_K().func_110577_a(FULL_TEXTURE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b((double)x, y1 + h1, 0.0).func_187315_a(0.0, v1).func_181675_d();
            buffer.func_181662_b((double)(x + w), y1 + h1, 0.0).func_187315_a(1.0, v1).func_181675_d();
            buffer.func_181662_b((double)(x + w), y1, 0.0).func_187315_a(1.0, v0).func_181675_d();
            buffer.func_181662_b((double)x, y1, 0.0).func_187315_a(0.0, v0).func_181675_d();
            tessellator.func_78381_a();
        }
        ClientUtils.MC.func_110434_K().func_110577_a(EMPTY_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_181662_b((double)x, (double)(y + h), 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)(y + h), 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b((double)(x + w), (double)y, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b((double)x, (double)y, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawScreen(@Nullable QuestTaskData data) {
        double r;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        ClientUtils.MC.func_110434_K().func_110577_a(EMPTY_TEXTURE);
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        double x = -0.5;
        double y = -0.5;
        double w = 1.0;
        double h = 1.0;
        double z = 0.0;
        buffer.func_181662_b(x, y + h, z).func_187315_a(0.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y + h, z).func_187315_a(1.0, 1.0).func_181675_d();
        buffer.func_181662_b(x + w, y, z).func_187315_a(1.0, 0.0).func_181675_d();
        buffer.func_181662_b(x, y, z).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        double d = r = data == null ? 0.0 : (double)data.getProgress() / (double)((QuestTask)data.task).getMaxProgress();
        if (r > 0.0) {
            x -= 0.0078125;
            w += 0.015625;
            y = 0.09375 + (1.0 - r) * 26.0 / 32.0 - 0.5;
            h = r * 26.0 / 32.0;
            y -= 0.0078125;
            h += 0.015625;
            z = 0.003;
            double u0 = 0.0;
            double v0 = 0.09375 + 0.8125 * (1.0 - r);
            double u1 = 1.0;
            double v1 = 0.90625;
            ClientUtils.MC.func_110434_K().func_110577_a(FULL_TEXTURE);
            buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            buffer.func_181662_b(x, y + h, z).func_187315_a(u0, v1).func_181675_d();
            buffer.func_181662_b(x + w, y + h, z).func_187315_a(u1, v1).func_181675_d();
            buffer.func_181662_b(x + w, y, z).func_187315_a(u1, v0).func_181675_d();
            buffer.func_181662_b(x, y, z).func_187315_a(u0, v0).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @Override
    public boolean hideProgressNumbers() {
        return !this.showNumbers;
    }

    @Override
    public QuestTaskData createData(ITeamData data) {
        return new Data(this, data);
    }

    public static class Data
    extends SimpleQuestTaskData<ManaTask>
    implements IManaReceiver {
        private Data(ManaTask task, ITeamData data) {
            super(task, data);
        }

        public boolean isFull() {
            return this.progress >= ((ManaTask)this.task).value;
        }

        public void recieveMana(int mana) {
            if (mana > 0 && this.progress < ((ManaTask)this.task).value) {
                long add = Math.min((long)mana, ((ManaTask)this.task).value - this.progress);
                if (((ManaTask)this.task).maxInput > 0L) {
                    add = Math.min(add, ((ManaTask)this.task).maxInput);
                }
                if (add > 0L) {
                    this.progress += add;
                    this.sync();
                }
            }
        }

        public boolean canRecieveManaFromBursts() {
            return !this.isFull();
        }

        public int getCurrentMana() {
            return 0;
        }
    }
}

