/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.gui.tree;

import com.feed_the_beast.ftblib.lib.gui.ContextMenu;
import com.feed_the_beast.ftblib.lib.gui.ContextMenuItem;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.GuiHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.util.FileUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.gui.FTBQuestsTheme;
import com.feed_the_beast.ftbquests.gui.GuiRewardTables;
import com.feed_the_beast.ftbquests.gui.GuiVariables;
import com.feed_the_beast.ftbquests.gui.tree.ButtonTab;
import com.feed_the_beast.ftbquests.net.MessageCompleteInstantly;
import com.feed_the_beast.ftbquests.net.MessageResetProgress;
import com.feed_the_beast.ftbquests.quest.Quest;
import com.feed_the_beast.ftbquests.quest.QuestChapter;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class ButtonEditSettings
extends ButtonTab {
    public ButtonEditSettings(Panel panel) {
        super(panel, I18n.func_135052_a((String)"gui.settings", (Object[])new Object[0]), GuiIcons.SETTINGS);
    }

    public void onClicked(MouseButton button) {
        GuiHelper.playClickSound();
        GuiBase gui = this.getGui();
        if (gui.contextMenu != null) {
            gui.closeContextMenu();
            return;
        }
        ArrayList<ContextMenuItem> contextMenu = new ArrayList<ContextMenuItem>();
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.edit_file", (Object[])new Object[0]), GuiIcons.SETTINGS, this.treeGui.file::onEditButtonClicked));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.reset_progress", (Object[])new Object[0]), GuiIcons.REFRESH, () -> new MessageResetProgress(this.treeGui.file.id).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.reset_progress_q", (Object[])new Object[0])));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly", (Object[])new Object[0]), FTBQuestsTheme.COMPLETED, () -> new MessageCompleteInstantly(this.treeGui.file.id).sendToServer()).setYesNo(I18n.func_135052_a((String)"ftbquests.gui.complete_instantly_q", (Object[])new Object[0])));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.variables", (Object[])new Object[0]), GuiIcons.CONTROLLER, () -> new GuiVariables().openGui()));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.reward_tables", (Object[])new Object[0]), GuiIcons.MONEY_BAG, () -> new GuiRewardTables().openGui()));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.save_as_file", (Object[])new Object[0]), GuiIcons.DOWN, () -> {
            try {
                NBTTagCompound nbt = new NBTTagCompound();
                ClientQuestFile.INSTANCE.writeDataFull(nbt);
                Calendar time = Calendar.getInstance();
                StringBuilder fileName = new StringBuilder("local/ftbquests/saved/");
                this.appendNum(fileName, time.get(1), '-');
                this.appendNum(fileName, time.get(2) + 1, '-');
                this.appendNum(fileName, time.get(5), '-');
                this.appendNum(fileName, time.get(11), '-');
                this.appendNum(fileName, time.get(12), '-');
                this.appendNum(fileName, time.get(13), '\u0000');
                fileName.append(".nbt");
                File file = new File(Minecraft.func_71410_x().field_71412_D, fileName.toString());
                NBTUtils.writeNBT((File)file, (NBTTagCompound)nbt);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("ftbquests.gui.saved_as_file", new Object[]{fileName.toString()}));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }));
        contextMenu.add(new ContextMenuItem(I18n.func_135052_a((String)"ftbquests.gui.export_spreadsheet", (Object[])new Object[0]), GuiIcons.DOWN, () -> {
            try {
                int maxQuests = 0;
                for (QuestChapter chapter : ClientQuestFile.INSTANCE.chapters) {
                    maxQuests = Math.max(maxQuests, chapter.quests.size());
                }
                String[][] cells = new String[ClientQuestFile.INSTANCE.chapters.size() * 2][maxQuests + 1];
                for (int x = 0; x < ClientQuestFile.INSTANCE.chapters.size(); ++x) {
                    QuestChapter c = (QuestChapter)ClientQuestFile.INSTANCE.chapters.get(x);
                    cells[x * 2][0] = c.getDisplayName().func_150260_c();
                    for (int y = 0; y < c.quests.size(); ++y) {
                        Quest q = c.quests.get(y);
                        cells[x * 2][y + 1] = q.getDisplayName().func_150260_c();
                    }
                }
                Calendar time = Calendar.getInstance();
                StringBuilder fileName = new StringBuilder("local/ftbquests/saved/");
                this.appendNum(fileName, time.get(1), '-');
                this.appendNum(fileName, time.get(2) + 1, '-');
                this.appendNum(fileName, time.get(5), '-');
                this.appendNum(fileName, time.get(11), '-');
                this.appendNum(fileName, time.get(12), '-');
                this.appendNum(fileName, time.get(13), '\u0000');
                fileName.append(".csv");
                File file = new File(Minecraft.func_71410_x().field_71412_D, fileName.toString());
                ArrayList<String> csv = new ArrayList<String>();
                for (int y = 0; y < maxQuests + 1; ++y) {
                    StringBuilder builder = new StringBuilder();
                    for (int x = 0; x < ClientQuestFile.INSTANCE.chapters.size() * 2; ++x) {
                        if (x > 0) {
                            builder.append(',');
                        }
                        builder.append('\"');
                        builder.append(cells[x][y] == null ? "" : cells[x][y]);
                        builder.append('\"');
                    }
                    csv.add(builder.toString());
                }
                FileUtils.saveSafe((File)file, csv);
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new TextComponentTranslation("ftbquests.gui.saved_as_file", new Object[]{fileName.toString()}));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }));
        ContextMenu panel = gui.openContextMenu(contextMenu);
        panel.setPos(gui.width - panel.width - 2, this.height + 1);
    }

    private void appendNum(StringBuilder sb, int num, char c) {
        if (num < 10) {
            sb.append('0');
        }
        sb.append(num);
        if (c != '\u0000') {
            sb.append(c);
        }
    }
}

