/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.command;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.command.CommandUtils;
import com.feed_the_beast.ftblib.lib.data.ForgeTeam;
import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.util.SidedUtils;
import com.feed_the_beast.ftbquests.quest.QuestVariable;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.util.FTBQuestsTeamData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandSetVariable
extends CommandBase {
    public String func_71517_b() {
        return "set_variable";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ftbquests.set_variable.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 1) {
            return CommandSetVariable.func_175762_a((String[])args, (Collection)Universe.get().getTeams());
        }
        if (args.length == 2) {
            ArrayList<String> list = new ArrayList<String>();
            for (QuestVariable variable : ServerQuestFile.INSTANCE.variables) {
                list.add(variable.toString());
            }
            list.sort(null);
            return CommandSetVariable.func_175762_a((String[])args, list);
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        Set<ForgeTeam> teams;
        if (args.length < 3) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        if (args[0].equals("*")) {
            teams = Universe.get().getTeams();
        } else {
            ForgeTeam team = Universe.get().getTeam(args[0]);
            if (!team.isValid()) {
                throw FTBLib.error((ICommandSender)sender, (String)"ftblib.lang.team.error.not_found", (Object[])new Object[]{args[0]});
            }
            teams = Collections.singleton(team);
        }
        int var = ServerQuestFile.INSTANCE.getID(args[1]);
        if (ServerQuestFile.INSTANCE.getVariable(var) == null) {
            throw CommandUtils.error((ITextComponent)SidedUtils.lang((ICommandSender)sender, (String)"ftbquests", (String)"commands.ftbquests.set_variable.invalid_id", (Object[])new Object[]{args[1]}));
        }
        boolean add = args[2].startsWith("~");
        long value = CommandSetVariable.func_175766_b((String)(add ? args[2].substring(1) : args[2]));
        for (ForgeTeam team : teams) {
            FTBQuestsTeamData teamData = FTBQuestsTeamData.get(team);
            if (add) {
                teamData.setVariable(var, teamData.getVariable(var) + value);
                continue;
            }
            teamData.setVariable(var, value);
        }
        sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ftbquests.set_variable.set", new Object[0]));
    }
}

