/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.command;

import com.feed_the_beast.ftblib.FTBLib;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftbquests.FTBQuests;
import com.feed_the_beast.ftbquests.net.edit.MessageEditObjectResponse;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.loot.RewardTable;
import com.feed_the_beast.ftbquests.quest.loot.WeightedReward;
import com.feed_the_beast.ftbquests.quest.reward.ItemReward;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class CommandImportRewardsFromChest
extends CommandBase {
    public String func_71517_b() {
        return "import_rewards_from_chest";
    }

    public String func_71518_a(ICommandSender sender) {
        return "commands.ftbquests.import_rewards_from_chest.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return sender instanceof EntityPlayerMP ? FTBQuests.canEdit((EntityPlayerMP)sender) : super.func_184882_a(server, sender);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length == 3) {
            return CommandImportRewardsFromChest.func_71530_a((String[])args, (String[])new String[]{"true", "false"});
        }
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>(ServerQuestFile.INSTANCE.rewardTables.size());
            for (RewardTable table : ServerQuestFile.INSTANCE.rewardTables) {
                list.add(table.getCodeString());
            }
            return CommandImportRewardsFromChest.func_175762_a((String[])args, list);
        }
        return super.func_184883_a(server, sender, args, pos);
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        IItemHandler handler;
        TileEntity tileEntity;
        EntityPlayerMP player = CommandImportRewardsFromChest.func_71521_c((ICommandSender)sender);
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        RewardTable table = ServerQuestFile.INSTANCE.getRewardTable(ServerQuestFile.INSTANCE.getID(args[0]));
        if (table == null) {
            throw FTBLib.error((ICommandSender)sender, (String)"commands.ftbquests.import_rewards_from_chest.invalid_id", (Object[])new Object[]{args[0]});
        }
        int weight = args.length >= 2 ? CommandImportRewardsFromChest.func_175764_a((String)args[1], (int)1, (int)Integer.MAX_VALUE) : 1;
        boolean replace = args.length >= 3 && CommandImportRewardsFromChest.func_180527_d((String)args[2]);
        RayTraceResult ray = MathUtils.rayTrace((EntityPlayer)player, (boolean)false);
        if (ray.field_72313_a == RayTraceResult.Type.BLOCK && (tileEntity = player.field_70170_p.func_175625_s(ray.func_178782_a())) != null && (handler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, ray.field_178784_b)) != null) {
            if (replace) {
                table.rewards.clear();
            }
            int r = 0;
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ItemReward itemReward = new ItemReward(table.fakeQuest);
                itemReward.stack = stack.func_77946_l();
                table.rewards.add(new WeightedReward(itemReward, weight));
                ++r;
            }
            ServerQuestFile.INSTANCE.clearCachedData();
            new MessageEditObjectResponse(table).sendToAll();
            ServerQuestFile.INSTANCE.save();
            sender.func_145747_a((ITextComponent)new TextComponentTranslation("commands.ftbquests.import_rewards_from_chest.text", new Object[]{r, table.getDisplayName()}));
        }
    }
}

