/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbquests.client;

import com.feed_the_beast.ftblib.lib.config.ConfigInt;
import com.feed_the_beast.ftblib.lib.config.ConfigValue;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.SimpleTextButton;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiButtonListBase;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiEditConfigValue;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiSelectFluid;
import com.feed_the_beast.ftblib.lib.gui.misc.GuiSelectItemStack;
import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.feed_the_beast.ftbquests.FTBQuestsCommon;
import com.feed_the_beast.ftbquests.client.ClientQuestFile;
import com.feed_the_beast.ftbquests.client.FTBQuestsClientEventHandler;
import com.feed_the_beast.ftbquests.quest.QuestFile;
import com.feed_the_beast.ftbquests.quest.ServerQuestFile;
import com.feed_the_beast.ftbquests.quest.reward.FTBQuestsRewards;
import com.feed_the_beast.ftbquests.quest.reward.ItemReward;
import com.feed_the_beast.ftbquests.quest.reward.XPLevelsReward;
import com.feed_the_beast.ftbquests.quest.reward.XPReward;
import com.feed_the_beast.ftbquests.quest.task.DimensionTask;
import com.feed_the_beast.ftbquests.quest.task.FTBQuestsTasks;
import com.feed_the_beast.ftbquests.quest.task.FluidTask;
import com.feed_the_beast.ftbquests.quest.task.ItemTask;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.item.ItemStack;
import net.minecraft.world.DimensionType;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.items.ItemHandlerHelper;

public class FTBQuestsClient
extends FTBQuestsCommon {
    public static KeyBinding KEY_QUESTS;

    @Override
    public void preInit() {
        KEY_QUESTS = new KeyBinding("key.ftbquests.quests", (IKeyConflictContext)KeyConflictContext.IN_GAME, Loader.isModLoaded((String)"ftbguides") ? KeyModifier.CONTROL : KeyModifier.NONE, 34, "key.categories.ftbmods");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_QUESTS);
    }

    @Override
    public void postInit() {
        FTBQuestsClientEventHandler.postInit();
    }

    @Override
    public QuestFile getQuestFile(boolean clientSide) {
        return clientSide ? ClientQuestFile.INSTANCE : ServerQuestFile.INSTANCE;
    }

    @Override
    public void setTaskGuiProviders() {
        FTBQuestsTasks.ITEM.setGuiProvider((gui, quest, callback) -> new GuiSelectItemStack(gui, stack -> {
            if (!stack.func_190926_b()) {
                ItemTask itemTask = new ItemTask(quest);
                itemTask.items.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                itemTask.count = stack.func_190916_E();
                if (!stack.func_77985_e()) {
                    itemTask.nbtMode = ItemTask.NBTMatchingMode.IGNORE;
                    itemTask.ignoreDamage = !stack.func_77981_g();
                }
                callback.accept(itemTask);
            }
        }).openGui());
        FTBQuestsTasks.FLUID.setGuiProvider((gui, quest, callback) -> new GuiSelectFluid(gui, () -> FluidRegistry.WATER, fluid -> {
            if (fluid != null) {
                FluidTask fluidTask = new FluidTask(quest);
                fluidTask.fluid = fluid;
                callback.accept(fluidTask);
            }
        }).openGui());
        FTBQuestsTasks.DIMENSION.setGuiProvider((gui, quest, callback) -> {
            GuiButtonListBase g = new GuiButtonListBase(){

                public void addButtons(Panel panel) {
                    for (final DimensionType type : DimensionType.values()) {
                        panel.add((Widget)new SimpleTextButton(panel, type.func_186065_b(), (Icon)Icon.EMPTY){

                            public void onClicked(MouseButton button) {
                                gui.openGui();
                                DimensionTask task = new DimensionTask(quest);
                                task.dimension = type;
                                callback.accept(task);
                            }
                        });
                    }
                }
            };
            g.focus();
            g.openGui();
        });
    }

    @Override
    public void setRewardGuiProviders() {
        FTBQuestsRewards.ITEM.setGuiProvider((gui, quest, callback) -> new GuiSelectItemStack(gui, stack -> {
            if (!stack.func_190926_b()) {
                ItemReward reward = new ItemReward(quest);
                reward.stack = stack;
                callback.accept(reward);
            }
        }).openGui());
        FTBQuestsRewards.XP.setGuiProvider((gui, quest, callback) -> new GuiEditConfigValue("xp", (ConfigValue)new ConfigInt(100, 1, Integer.MAX_VALUE), (value, set) -> {
            gui.openGui();
            if (set) {
                XPReward reward = new XPReward(quest);
                reward.xp = value.getInt();
                callback.accept(reward);
            }
        }).openGui());
        FTBQuestsRewards.XP_LEVELS.setGuiProvider((gui, quest, callback) -> new GuiEditConfigValue("xp_levels", (ConfigValue)new ConfigInt(1, 1, Integer.MAX_VALUE), (value, set) -> {
            gui.openGui();
            if (set) {
                XPLevelsReward reward = new XPLevelsReward(quest);
                reward.xpLevels = value.getInt();
                callback.accept(reward);
            }
        }).openGui());
    }
}

