/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.helpers;

import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.ClientRunnable;
import forestry.api.apiculture.IBeeHousing;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NameHelper {
    public static final NameHelper QUEEN_NAMES = new NameHelper("carrerbees.queen.names.");
    @Nonnull
    public static NameHelper TAXES = new NameHelper("beemod.text.taxpayer.tax.");
    private final String prefix;
    int numNames = -1;

    public void resetNum(Object dummy) {
        this.numNames = -1;
    }

    public NameHelper(String prefix) {
        BeeMod.proxy.run(new ClientRunnable(){

            @Override
            @SideOnly(value=Side.CLIENT)
            public void run() {
                ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a(NameHelper.this::resetNum);
            }
        });
        this.prefix = prefix;
    }

    public static short getQueenNameSeed(@Nonnull IBeeHousing housing) {
        ItemStack queen = housing.getBeeInventory().getQueen();
        if (queen.func_190926_b()) {
            return NameHelper.newSeed(housing);
        }
        NBTTagCompound compound = queen.func_77978_p();
        if (compound == null) {
            return NameHelper.newSeed(housing);
        }
        if (compound.func_150297_b("name_seed", 2)) {
            return compound.func_74765_d("name_seed");
        }
        short value = NameHelper.newSeed(housing);
        compound.func_74777_a("name_seed", value);
        queen.func_77982_d(compound);
        housing.getBeeInventory().setQueen(queen);
        return value;
    }

    private static short newSeed(@Nonnull IBeeHousing housing) {
        return (short)housing.getWorldObj().field_73012_v.nextInt(16384);
    }

    @Nonnull
    public String getName(int seed) {
        int i;
        if (this.numNames == -1) {
            i = 0;
            while (I18n.func_94522_b((String)(this.prefix + i))) {
                ++i;
            }
            if (i == 0) {
                i = 1;
            }
            this.numNames = i;
        }
        i = Math.abs(seed) % this.numNames;
        return I18n.func_74838_a((String)(this.prefix + i));
    }
}

