/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.rwtema.careerbees.blocks.TileFlowerPedastal;
import com.rwtema.careerbees.effects.EffectFoodModify;
import com.rwtema.careerbees.lang.Lang;
import forestry.api.apiculture.IBeeGenome;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.FoodStats;

public class EffectSalt
extends EffectFoodModify {
    final float MAX = 2.0f;

    public EffectSalt(String name, float baseTicksBetweenProcessing) {
        super(name, baseTicksBetweenProcessing);
    }

    public EffectSalt(String name, boolean isDominant, boolean isCombinable, float baseTicksBetweenProcessing, float chanceOfProcessing) {
        super(name, isDominant, isCombinable, baseTicksBetweenProcessing, chanceOfProcessing);
    }

    @Override
    protected boolean shouldBeginEattingOverride(EntityPlayer entityPlayer, ItemStack itemStack, NBTTagCompound compoundTag) {
        return false;
    }

    @Override
    protected void addTooltip(ItemStack itemStack, @Nonnull NBTTagCompound compoundTag, @Nonnull List<String> toolTip) {
        float current = compoundTag.func_74760_g("current");
        if (current > 0.0f) {
            toolTip.add(ChatFormatting.YELLOW + Lang.translateArgs("Salted: +%s Hunger Filled, -%s Saturation", NumberFormat.getPercentInstance(Locale.UK).format(current), NumberFormat.getPercentInstance(Locale.UK).format(current / 2.0f)));
        }
    }

    @Override
    public void callback(@Nonnull EntityPlayer player, @Nonnull NBTTagCompound tag, @Nonnull ItemStack stack) {
        float current = tag.func_74760_g("current");
        if (!(stack.func_77973_b() instanceof ItemFood)) {
            return;
        }
        ItemFood food = (ItemFood)stack.func_77973_b();
        int healAmount = food.func_150905_g(stack);
        float saturationModifier = food.func_150906_h(stack);
        FoodStats foodStats = player.func_71024_bL();
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        foodStats.func_75117_b(nbtTagCompound);
        int curFoodLevel = nbtTagCompound.func_74762_e("foodLevel");
        float curSaturation = nbtTagCompound.func_74760_g("foodSaturationLevel");
        int newFoodLevel = Math.min(Math.round((float)healAmount * current + (float)curFoodLevel), 20);
        float newFoodSaturationLevel = Math.max(curSaturation - (float)curFoodLevel * saturationModifier * current, 0.0f);
        nbtTagCompound.func_74768_a("foodLevel", newFoodLevel);
        nbtTagCompound.func_74776_a("foodSaturationLevel", newFoodSaturationLevel);
        foodStats.func_75112_a(nbtTagCompound);
    }

    @Override
    protected boolean shouldRelease(IBeeGenome genome, TileFlowerPedastal frame, @Nonnull NBTTagCompound curTag) {
        return curTag.func_74760_g("current") >= 2.0f;
    }

    @Override
    @Nullable
    protected NBTTagCompound addData(IBeeGenome genome, ItemStack stack, @Nullable NBTTagCompound prevTag) {
        float current;
        float f = current = prevTag != null ? prevTag.func_74760_g("current") : 0.0f;
        if (current >= 2.0f) {
            return null;
        }
        float newCurrent = Math.min(current * 0.75f + 0.5f + 0.05f, 2.0f);
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74776_a("current", newCurrent);
        return nbtTagCompound;
    }

    @Override
    public boolean acceptItemStack(ItemStack stack, @Nullable NBTTagCompound curTag) {
        return curTag == null || curTag.func_74760_g("current") < 2.0f;
    }
}

