/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.core.jei.shredder;

import com.gendeathrow.hatchery.api.crafting.ShredderRecipe;
import com.gendeathrow.hatchery.core.jei.shredder.ShredderRecipeWrapper;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class ShredderCategory
implements IRecipeCategory<ShredderRecipeWrapper>,
IRecipeWrapperFactory<ShredderRecipe> {
    public static final String UID = "hatchery.shredder.recipe";
    private final ResourceLocation location = new ResourceLocation("hatchery", "textures/gui/shredder_recipes.png");
    private final String title = I18n.func_135052_a((String)"jei.gui.shredder_recipes", (Object[])new Object[0]);
    private final IDrawableStatic background;
    private final IDrawableAnimated arrow;
    private final IDrawableStatic icon;

    public ShredderCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(this.location, 0, 0, 91, 78);
        IDrawableStatic arrowDrawable = guiHelper.createDrawable(this.location, 91, 0, 15, 17);
        this.arrow = guiHelper.createAnimatedDrawable(arrowDrawable, 200, IDrawableAnimated.StartDirection.TOP, false);
        this.icon = guiHelper.createDrawable(this.location, 91, 17, 16, 16);
    }

    public void drawExtras(Minecraft minecraft) {
        this.arrow.draw(minecraft, 29, 28);
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUid() {
        return UID;
    }

    public void setRecipe(IRecipeLayout recipeLayout, ShredderRecipeWrapper recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 28, 9);
        guiItemStacks.init(1, false, 18, 47);
        guiItemStacks.init(2, false, 39, 47);
        guiItemStacks.init(3, true, 68, 27);
        guiItemStacks.set(ingredients);
    }

    public String getModName() {
        return "Hatchery";
    }

    public IDrawable getIcon() {
        return null;
    }

    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    public IRecipeWrapper getRecipeWrapper(ShredderRecipe recipe) {
        return new ShredderRecipeWrapper(recipe);
    }
}

