/*
 * Decompiled with CFR 0.152.
 */
package com.gendeathrow.hatchery.block.feeder;

import com.gendeathrow.hatchery.block.feeder.FeederBlock;
import com.gendeathrow.hatchery.core.init.ModItems;
import com.gendeathrow.hatchery.storage.InventoryStroageModifiable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemSeeds;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class FeederTileEntity
extends TileEntity {
    private int seedInventory = 0;
    private int maxSeedInventory = 200;
    protected InventoryStroageModifiable inventory = new InventoryStroageModifiable("inputItems", 1){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return FeederTileEntity.this.isItemValidForSlot(slot, stack);
        }

        @Override
        public boolean canExtractSlot(int slot) {
            return false;
        }

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack stackReturn = super.insertItem(slot, stack, simulate);
            FeederTileEntity.this.updateTile();
            return stackReturn;
        }
    };

    public void updateTile() {
        this.convertSeeds();
    }

    public void func_145839_a(NBTTagCompound compound) {
        this.seedInventory = compound.func_74762_e("seeds");
        super.func_145839_a(compound);
    }

    public void convertSeeds() {
        if (this.hasSeeds() && this.seedInventory < this.maxSeedInventory) {
            this.addSeeds(this.getSeedsSlot().func_190916_E(), this.getSeedsSlot(), false);
            FeederBlock.setFeederLevel(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound.func_74768_a("seeds", this.seedInventory);
        return super.func_189515_b(compound);
    }

    public ItemStack getSeedsSlot() {
        return this.inventory.getStackInSlot(0);
    }

    public boolean hasSeeds() {
        return !this.getSeedsSlot().func_190926_b();
    }

    public int getSeedsInv() {
        return this.seedInventory;
    }

    public void decrSeedsInv() {
        if (this.seedInventory-- < 0) {
            this.seedInventory = 0;
        }
        FeederBlock.setFeederLevel(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
    }

    public int getMaxSeedInv() {
        return this.maxSeedInventory;
    }

    public void dropContents() {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack stack = this.inventory.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), stack));
        }
    }

    public void setSeeds(int qty) {
        this.seedInventory = qty;
    }

    boolean isItemValidForSlot(int index, ItemStack stack) {
        return this.seedInventory < this.maxSeedInventory ? stack.func_77973_b() instanceof ItemSeeds || stack.func_77973_b() == ModItems.chickenFeed : false;
    }

    public void addSeeds(int qty, ItemStack stack, boolean creative) {
        if (this.isItemValidForSlot(0, stack) && !stack.func_190926_b() && this.seedInventory < this.maxSeedInventory) {
            this.seedInventory += qty;
            if (this.seedInventory > this.maxSeedInventory) {
                qty -= this.seedInventory - this.maxSeedInventory;
                this.seedInventory = this.maxSeedInventory;
            }
            if (!creative) {
                stack.func_190918_g(qty);
            }
            FeederBlock.setFeederLevel(this.field_145850_b, this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c));
        }
        this.func_70296_d();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.inventory);
        }
        return (T)super.getCapability(capability, facing);
    }
}

