/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.setycz.chickens.ChickensMod;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class JsonConfig {
    boolean hasChanged = false;
    private File configFile;
    private JsonObject json;
    private Gson gson;

    public JsonConfig(File file) {
        this.configFile = file;
        this.gson = new Gson();
        this.json = new JsonObject();
    }

    public void Save() {
        this.WriteFile();
        this.hasChanged = false;
    }

    public void Load() {
        try {
            this.SetupFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.json = this.ReadFile();
    }

    public JsonObject getFullJson() {
        return this.json;
    }

    public JsonObject getCategory(String categoryProperty) {
        JsonObject object = new JsonObject();
        if (this.json.has(categoryProperty)) {
            object = this.json.getAsJsonObject(categoryProperty);
        } else {
            this.json.add(categoryProperty, (JsonElement)object);
            this.setHasChanged(true);
        }
        return object;
    }

    public boolean getBoolean(String categoryProperty, String property, boolean value) {
        JsonObject object = this.getCategory(categoryProperty);
        if (object.has(property)) {
            value = object.get(property).getAsBoolean();
        } else {
            object.addProperty(property, Boolean.valueOf(value));
            this.setHasChanged(true);
        }
        return value;
    }

    public String getString(String categoryProperty, String property, String value) {
        JsonObject object = this.getCategory(categoryProperty);
        if (object.has(property)) {
            value = object.get(property).getAsString();
        } else {
            object.addProperty(property, value);
            this.setHasChanged(true);
        }
        return value;
    }

    public float getFloat(String categoryProperty, String property, float value, float min, float max) {
        JsonObject object = this.getCategory(categoryProperty);
        if (object.has(property)) {
            value = object.get(property).getAsFloat();
        } else {
            object.addProperty(property, (Number)Float.valueOf(value));
            this.setHasChanged(true);
        }
        if (value > max) {
            value = max;
        }
        if (value < min) {
            value = min;
        }
        return value;
    }

    @Nullable
    public ItemStack getItemStack(String categoryProperty, String property, ItemStack stack) {
        JsonObject object = this.getCategory(categoryProperty);
        if (object.has(property)) {
            stack = JsonConfig.getItemStackFromID(object.get(property).getAsString());
        } else {
            object.addProperty(property, JsonConfig.getIDfromItemStack(stack));
            this.setHasChanged(true);
        }
        return stack;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    protected void setHasChanged(boolean val) {
        this.hasChanged = val;
    }

    private void SetupFile() throws IOException {
        if (!this.configFile.exists()) {
            this.hasChanged = true;
            this.configFile.getParentFile().mkdirs();
            this.configFile.createNewFile();
        }
    }

    protected JsonObject ReadFile() {
        JsonObject obj = new JsonObject();
        try {
            FileReader fr = new FileReader(this.configFile);
            JsonObject jsonobject = (JsonObject)this.gson.fromJson((Reader)fr, JsonObject.class);
            fr.close();
            return jsonobject != null ? jsonobject : obj;
        }
        catch (Exception e) {
            throw new RuntimeException("Error " + e.getCause() + " loading file: " + this.configFile.getPath());
        }
    }

    protected void WriteFile() {
        try {
            FileWriter fw = new FileWriter(this.configFile);
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)this.json, (Appendable)fw);
            fw.flush();
            fw.close();
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    protected static String getIDfromItemStack(ItemStack stack) {
        return stack.func_77973_b().getRegistryName() + (stack.func_77960_j() != 0 || stack.func_190916_E() > 1 ? ":" + stack.func_77960_j() + (stack.func_190916_E() > 1 ? ":" + stack.func_190916_E() : "") : "");
    }

    @Nullable
    protected static ItemStack getItemStackFromID(String itemID) {
        String[] args = itemID.split(":");
        ItemStack stack = null;
        Item item = null;
        int meta = 0;
        int qty = 1;
        if (args.length >= 2) {
            item = Item.func_111206_d((String)(args[0] + ":" + args[1]));
        }
        if (args.length >= 3) {
            try {
                meta = Integer.parseInt(args[2]);
            }
            catch (Exception e) {
                ChickensMod.log.error("Could not parse meta value: " + itemID);
            }
        }
        if (args.length == 4) {
            try {
                qty = Integer.parseInt(args[3]);
            }
            catch (Exception e) {
                ChickensMod.log.error("Could not parse qty value: " + itemID);
            }
        }
        if (item != null) {
            stack = new ItemStack(item, qty, meta);
        } else {
            ChickensMod.log.error("Item could not be Found: " + itemID);
        }
        return stack;
    }
}

