/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.config;

import com.setycz.chickens.config.JsonConfig;
import com.setycz.chickens.handler.SpawnType;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.Configuration;

public class ConfigHandler {
    public static final File configDir = new File("config/chickens");
    public static final File ChickensMainFile = new File(configDir, "main_chickens.cfg");
    public static final File ChickensFile = new File(configDir, "chickens.json");
    private static JsonConfig config;
    public static ArrayList<String> ErrorList;
    public static int chickenEntityId;
    public static int spawnProbability;
    public static int minBroodSize;
    public static int maxBroodSize;
    public static float netherSpawnChanceMultiplier;
    public static boolean alwaysShowStats;

    public static void LoadConfigs(List<ChickensRegistryItem> allchickens) {
        ConfigHandler.loadConfiguration();
        ConfigHandler.loadChickens(allchickens);
    }

    private static void loadConfiguration() {
        Configuration mainConfig = new Configuration(ChickensMainFile);
        mainConfig.load();
        chickenEntityId = mainConfig.getInt("entityId", "general", 30000, Integer.MIN_VALUE, Integer.MAX_VALUE, "Chicken Entity ID");
        spawnProbability = mainConfig.getInt("spawnProbability", "general", 10, Integer.MIN_VALUE, Integer.MAX_VALUE, "Spawn probability");
        minBroodSize = mainConfig.getInt("minBroodSize", "general", 3, 1, Integer.MAX_VALUE, "Minimal brood size");
        maxBroodSize = mainConfig.getInt("maxBroodSize", "general", 5, 2, Integer.MAX_VALUE, "Maximal brood size, must be greater than the minimal size");
        netherSpawnChanceMultiplier = mainConfig.getFloat("netherSpawnChanceMultiplier", "general", 1.0f, 0.0f, Float.MAX_VALUE, "Nether chicken spawn chance multiplier, e.g. 0=no initial spawn, 2=two times more spawn rate");
        alwaysShowStats = mainConfig.getBoolean("alwaysShowStats", "general", false, "Stats will be always shown in WAILA without the need to analyze chickens first when enabled.");
        if (mainConfig.hasChanged()) {
            mainConfig.save();
        }
    }

    public static void loadChickens(Collection<ChickensRegistryItem> allChickens) {
        config = new JsonConfig(ChickensFile);
        config.Load();
        String comment = "_comment";
        config.getString(comment, "name", "Just a Reference to the old system naming. Changing does nothing.");
        config.getString(comment, "is_enabled", "Is chicken enabled?");
        config.getString(comment, "lay_item", "Item the chicken will Lay.               modid:itemid:metadata:amount #example: minecraft:log:2:3");
        config.getString(comment, "drop_item", "Item the chicken drops on death.        modid:itemid:metadata:amount #example: minecraft:bone");
        config.getString(comment, "spawn_type", "Chicken spawn type, can be: " + String.join((CharSequence)",", SpawnType.names()));
        config.getString(comment, "parent_1", "First parent, empty if it cant be breed. modid:chickenid #example: chickens:waterchicken");
        config.getString(comment, "parent_2", "Second parent, empty if it cant be breed. ");
        for (ChickensRegistryItem chicken : allChickens) {
            String registryName = chicken.getRegistryName().toString();
            config.getString(registryName, "name", chicken.getEntityName());
            boolean enabled = config.getBoolean(registryName, "is_enabled", true);
            chicken.setEnabled(enabled);
            float layCoefficient = config.getFloat(registryName, "lay_coefficient", 1.0f, 0.01f, 100.0f);
            chicken.setLayCoefficient(layCoefficient);
            chicken.setLayItem(ConfigHandler.loadItemStack(config, registryName, chicken, "lay_item", chicken.createLayItem()));
            chicken.setDropItem(ConfigHandler.loadItemStack(config, registryName, chicken, "drop_item", chicken.createDropItem()));
            SpawnType spawnType = SpawnType.valueOf(config.getString(registryName, "spawn_type", chicken.getSpawnType().toString()));
            chicken.setSpawnType(spawnType);
            ChickensRegistry.register(chicken);
        }
        for (ChickensRegistryItem chicken : allChickens) {
            ChickensRegistryItem parent1 = ChickensRegistry.getByRegistryName(ConfigHandler.getChickenParent(config, "parent_1", allChickens, chicken, chicken.getParent1()));
            ChickensRegistryItem parent2 = ChickensRegistry.getByRegistryName(ConfigHandler.getChickenParent(config, "parent_2", allChickens, chicken, chicken.getParent2()));
            if (parent1 != null && parent2 != null) {
                chicken.setParentsNew(parent1, parent2);
                continue;
            }
            chicken.setNoParents();
        }
        if (ConfigHandler.config.hasChanged) {
            config.Save();
        }
    }

    private static String getChickenParent(JsonConfig configuration, String propertyName, Collection<ChickensRegistryItem> allChickens, ChickensRegistryItem chicken, ChickensRegistryItem parent) {
        String Category = chicken.getRegistryName().toString();
        return configuration.getString(Category, propertyName, parent != null ? parent.getRegistryName().toString() : "");
    }

    private static ItemStack loadItemStack(JsonConfig configuration, String Category, ChickensRegistryItem chicken, String prefix, ItemStack defaultItemStack) {
        ItemStack stack = configuration.getItemStack(Category, prefix, defaultItemStack);
        if (stack == null || stack.func_190926_b()) {
            if (defaultItemStack != null) {
                return defaultItemStack;
            }
            throw new RuntimeException("Cannot find " + prefix + " for " + chicken.getRegistryName().toString());
        }
        return stack;
    }

    static {
        ErrorList = new ArrayList();
        chickenEntityId = 30000;
        spawnProbability = 10;
        minBroodSize = 3;
        maxBroodSize = 5;
        netherSpawnChanceMultiplier = 1.0f;
        alwaysShowStats = false;
    }
}

