/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.block;

import com.setycz.chickens.capabilities.InventoryStroageModifiable;
import com.setycz.chickens.client.gui.GuiHenhouse;
import com.setycz.chickens.client.gui.IInventoryGui;
import com.setycz.chickens.client.gui.container.ContainerHenhouse;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityHenhouse
extends TileEntity
implements IInventoryGui {
    public static final int hayBaleEnergy = 100;
    public static final int hayBaleSlotIndex = 0;
    public static final int dirtSlotIndex = 1;
    public static final int firstItemSlotIndex = 2;
    private static final int lastItemSlotIndex = 10;
    private static final double HENHOUSE_RADIUS = 0.5;
    private static final double FENCE_THRESHOLD = 0.5;
    private String customName;
    private final InventoryStroageModifiable slots = new InventoryStroageModifiable("container.henhouse", 11){

        @Override
        public boolean canInsertSlot(int slotIndex, ItemStack stackIn) {
            if (slotIndex == 0 && stackIn.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150407_cf)) {
                return true;
            }
            return slotIndex == 1 && stackIn.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150346_d);
        }

        @Override
        public boolean canExtractSlot(int slotIndex) {
            return slotIndex != 0;
        }
    };
    private int energy = 0;

    @Nullable
    public static ItemStack pushItemStack(ItemStack itemToLay, World worldObj, Vec3d pos) {
        TileEntityHenhouse henhouse;
        List<TileEntityHenhouse> henhouses = TileEntityHenhouse.findHenhouses(worldObj, pos, 5.0);
        Iterator<TileEntityHenhouse> iterator = henhouses.iterator();
        while (iterator.hasNext() && !(itemToLay = (henhouse = iterator.next()).pushItemStack(itemToLay)).func_190926_b()) {
        }
        return itemToLay;
    }

    private static List<TileEntityHenhouse> findHenhouses(World worldObj, Vec3d pos, double radius) {
        int firstChunkX = MathHelper.func_76128_c((double)((pos.field_72450_a - radius - World.MAX_ENTITY_RADIUS) / 16.0));
        int lastChunkX = MathHelper.func_76128_c((double)((pos.field_72450_a + radius + World.MAX_ENTITY_RADIUS) / 16.0));
        int firstChunkY = MathHelper.func_76128_c((double)((pos.field_72449_c - radius - World.MAX_ENTITY_RADIUS) / 16.0));
        int lastChunkY = MathHelper.func_76128_c((double)((pos.field_72449_c + radius + World.MAX_ENTITY_RADIUS) / 16.0));
        ArrayList<Double> distances = new ArrayList<Double>();
        ArrayList<TileEntityHenhouse> result = new ArrayList<TileEntityHenhouse>();
        for (int chunkX = firstChunkX; chunkX <= lastChunkX; ++chunkX) {
            for (int chunkY = firstChunkY; chunkY <= lastChunkY; ++chunkY) {
                Chunk chunk = worldObj.func_72964_e(chunkX, chunkY);
                for (TileEntity tileEntity : chunk.func_177434_r().values()) {
                    Vec3d tileEntityPos;
                    boolean inRage;
                    if (!(tileEntity instanceof TileEntityHenhouse) || !(inRage = TileEntityHenhouse.testRange(pos, tileEntityPos = new Vec3d((Vec3i)tileEntity.func_174877_v()).func_72441_c(0.5, 0.5, 0.5), radius))) continue;
                    double distance = pos.func_72438_d(tileEntityPos);
                    TileEntityHenhouse.addHenhouseToResults((TileEntityHenhouse)tileEntity, distance, distances, result);
                }
            }
        }
        return result;
    }

    private static boolean testRange(Vec3d pos1, Vec3d pos2, double range) {
        return Math.abs(pos1.field_72450_a - pos2.field_72450_a) <= range && Math.abs(pos1.field_72448_b - pos2.field_72448_b) <= range && Math.abs(pos1.field_72449_c - pos2.field_72449_c) <= range;
    }

    private static void addHenhouseToResults(TileEntityHenhouse henhouse, double distance, List<Double> distances, List<TileEntityHenhouse> henhouses) {
        for (int resultIndex = 0; resultIndex < distances.size(); ++resultIndex) {
            if (!(distance < distances.get(resultIndex))) continue;
            distances.add(resultIndex, distance);
            henhouses.add(resultIndex, henhouse);
            return;
        }
        distances.add(distance);
        henhouses.add(henhouse);
    }

    private ItemStack pushItemStack(ItemStack stack) {
        int capacity = this.getEffectiveCapacity();
        if (capacity <= 0) {
            return stack;
        }
        for (int slotIndex = 2; slotIndex <= 10 && !stack.func_190926_b(); ++slotIndex) {
            ItemStack simulated;
            int stackSizePre = stack.func_190916_E();
            int powerToUse = stackSizePre - (simulated = this.slots.insertItemInternal(slotIndex, stack, true)).func_190916_E();
            if (powerToUse <= 0) continue;
            this.consumeEnergy(powerToUse);
            capacity -= powerToUse;
            stack = this.slots.insertItemInternal(slotIndex, stack, false);
        }
        this.func_70296_d();
        return stack;
    }

    private void consumeEnergy(int amount) {
        while (amount > 0) {
            if (this.energy == 0) {
                assert (!this.slots.getStackInSlot(0).func_190926_b());
                this.slots.extractItemInternal(0, 1, false);
                this.energy += 100;
            }
            int consumed = Math.min(amount, this.energy);
            this.energy -= consumed;
            amount -= consumed;
            if (this.energy > 0) continue;
            this.slots.insertItemInternal(1, new ItemStack(Blocks.field_150346_d, 1), false);
        }
    }

    private int getEffectiveCapacity() {
        return Math.min(this.getInputCapacity(), this.getOutputCapacity());
    }

    private int getInputCapacity() {
        int potential = this.energy;
        ItemStack hayBaleStack = this.slots.getStackInSlot(0);
        if (!hayBaleStack.func_190926_b() && hayBaleStack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150407_cf)) {
            potential += hayBaleStack.func_190916_E() * 100;
        }
        return potential;
    }

    private int getOutputCapacity() {
        ItemStack dirtStack = this.slots.getStackInSlot(1);
        if (dirtStack.func_190926_b()) {
            return this.slots.getSlotLimit(1) * 100;
        }
        if (dirtStack.func_77973_b() != Item.func_150898_a((Block)Blocks.field_150346_d)) {
            return 0;
        }
        return (this.slots.getSlotLimit(1) - dirtStack.func_190916_E()) * 100;
    }

    public void dropContents() {
        for (int i = 0; i < this.slots.getSlots(); ++i) {
            ItemStack stack = this.slots.extractItemInternal(i, this.slots.getSlotLimit(i), false);
            if (stack.func_190926_b()) continue;
            this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)(this.field_174879_c.func_177956_o() + 1), (double)this.field_174879_c.func_177952_p(), stack));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("energy", this.energy);
        this.slots.writeToNBT(compound);
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.energy = compound.func_74762_e("energy");
        this.slots.readFromNBT(compound);
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.energy;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.energy = value;
            }
        }
    }

    public int getFieldCount() {
        return 1;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.slots.getName(), new Object[0]);
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    @Override
    public Container createContainer(InventoryPlayer inventoryplayer) {
        return new ContainerHenhouse(inventoryplayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer createGui(InventoryPlayer inventoryplayer) {
        return new GuiHenhouse(inventoryplayer, this);
    }

    public int getEnergy() {
        return this.energy;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.slots);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

