/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vliblegacy.lib.tile.energy;

import com.valkyrieofnight.vliblegacy.lib.tile.tickable.VLTileTickable;
import com.valkyrieofnight.vliblegacy.lib.tilemodule.energyu.ITileUEConsumer;
import com.valkyrieofnight.vliblegacy.lib.tilemodule.energyu.TileModuleUEnergy;
import com.valkyrieofnight.vliblegacy.lib.tilemodule.energyu.storage.UEnergyConsumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

public abstract class VLTileEnergyConsumer
extends VLTileTickable
implements ITileUEConsumer {
    protected boolean ic2EU = true;
    protected boolean bcMJ = true;
    protected UEnergyConsumer eBuffer;

    public VLTileEnergyConsumer(int capacity) {
        this(capacity, capacity);
    }

    public VLTileEnergyConsumer(int capacity, int maxReceive) {
        this.eBuffer = new UEnergyConsumer(capacity, maxReceive);
        this.addModule(new TileModuleUEnergy(this));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && (facing == null || this.canEnergyConnect(facing))) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY && (facing == null || this.canEnergyConnect(facing))) {
            return (T)this.eBuffer;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public NBTTagCompound saveTileData(NBTTagCompound nbt, boolean toItem) {
        super.saveTileData(nbt, toItem);
        this.eBuffer.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public void loadTileData(NBTTagCompound nbt, boolean fromItem) {
        super.loadTileData(nbt, fromItem);
        this.eBuffer.readFromNBT(nbt);
    }

    public UEnergyConsumer getEBuffer() {
        return this.eBuffer;
    }

    protected abstract boolean canEnergyConnect(EnumFacing var1);

    @Optional.Method(modid="valkyriecompat")
    public boolean acceptsIc2EnergyFrom(EnumFacing side) {
        return !this.ic2EU ? false : this.canEnergyConnect(side);
    }

    @Optional.Method(modid="valkyriecompat")
    public double injectIc2Energy(EnumFacing directionFrom, double amount, double voltage) {
        return this.eBuffer.injectIc2Energy(amount, voltage);
    }

    @Optional.Method(modid="valkyriecompat")
    public double getIc2DemandedEnergy() {
        return this.eBuffer.getIc2DemandedEnergy();
    }

    @Optional.Method(modid="valkyriecompat")
    public int getIc2Tier() {
        return Integer.MAX_VALUE;
    }
}

