/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.items;

import javax.annotation.Nonnull;
import moze_intel.projecte.api.PESounds;
import moze_intel.projecte.api.item.IItemCharge;
import moze_intel.projecte.api.item.IProjectileShooter;
import moze_intel.projecte.gameObjs.entity.EntityLensProjectile;
import moze_intel.projecte.gameObjs.items.ItemPE;
import moze_intel.projecte.utils.Constants;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class HyperkineticLens
extends ItemPE
implements IProjectileShooter,
IItemCharge {
    public HyperkineticLens() {
        this.func_77655_b("hyperkinetic_lens");
        this.func_77625_d(1);
        this.setNoRepair();
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && this.shootProjectile(player, stack, hand)) {
            PlayerHelper.swingItem(player, hand);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public boolean shootProjectile(@Nonnull EntityPlayer player, @Nonnull ItemStack stack, EnumHand hand) {
        World world = player.func_130014_f_();
        int requiredEmc = Constants.EXPLOSIVE_LENS_COST[this.getCharge(stack)];
        if (!HyperkineticLens.consumeFuel(player, stack, requiredEmc, true)) {
            return false;
        }
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PESounds.POWER, SoundCategory.PLAYERS, 1.0f, 1.0f);
        EntityLensProjectile ent = new EntityLensProjectile(world, player, this.getCharge(stack));
        ent.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.5f, 1.0f);
        world.func_72838_d((Entity)ent);
        return true;
    }

    @Override
    public int getNumCharges(@Nonnull ItemStack stack) {
        return 3;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)this.getCharge(stack) / (double)this.getNumCharges(stack);
    }
}

