/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.emc;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import mezz.jei.api.recipe.IRecipeWrapper;
import moze_intel.projecte.PECore;
import moze_intel.projecte.emc.EMCMapper;
import moze_intel.projecte.emc.SimpleStack;
import moze_intel.projecte.gameObjs.ObjHandler;
import moze_intel.projecte.integration.jei.PEJeiPlugin;
import moze_intel.projecte.integration.jei.collectors.FuelUpgradeRecipe;
import moze_intel.projecte.utils.EMCHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public final class FuelMapper {
    private static final List<SimpleStack> FUEL_MAP = new ArrayList<SimpleStack>();
    private static List<FuelUpgradeRecipe> jeiRecipeList = new ArrayList<FuelUpgradeRecipe>();

    public static void loadMap() {
        FUEL_MAP.clear();
        FuelMapper.addToMap(new ItemStack(Items.field_151044_h, 1, 1));
        FuelMapper.addToMap(new ItemStack(Items.field_151137_ax));
        FuelMapper.addToMap(new ItemStack(Blocks.field_150451_bX));
        FuelMapper.addToMap(new ItemStack(Items.field_151044_h));
        FuelMapper.addToMap(new ItemStack(Blocks.field_150402_ci));
        FuelMapper.addToMap(new ItemStack(Items.field_151016_H));
        FuelMapper.addToMap(new ItemStack(Items.field_151114_aO));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuels, 1, 0));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuelBlock, 1, 0));
        FuelMapper.addToMap(new ItemStack(Items.field_151065_br));
        FuelMapper.addToMap(new ItemStack(Blocks.field_150426_aN));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuels, 1, 1));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuelBlock, 1, 1));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuels, 1, 2));
        FuelMapper.addToMap(new ItemStack(ObjHandler.fuelBlock, 1, 2));
        FUEL_MAP.sort(Comparator.comparing(EMCMapper::getEmcValue));
        PEJeiPlugin.refreshJEI();
    }

    private static void addToMap(ItemStack stack) {
        if (EMCHelper.doesItemHaveEmc(stack)) {
            FuelMapper.addToMap(new SimpleStack(stack));
        }
    }

    public static boolean isStackFuel(ItemStack stack) {
        return FuelMapper.mapContains(new SimpleStack(stack));
    }

    public static boolean isStackMaxFuel(ItemStack stack) {
        return FUEL_MAP.indexOf(new SimpleStack(stack)) == FUEL_MAP.size() - 1;
    }

    public static ItemStack getFuelUpgrade(ItemStack stack) {
        SimpleStack fuel = new SimpleStack(stack);
        int index = FUEL_MAP.indexOf(fuel);
        if (index == -1) {
            PECore.LOGGER.warn("Tried to upgrade invalid fuel: {}", (Object)stack);
            return ItemStack.field_190927_a;
        }
        int nextIndex = index == FUEL_MAP.size() - 1 ? 0 : index + 1;
        return FUEL_MAP.get(nextIndex).toItemStack();
    }

    private static void addToMap(SimpleStack stack) {
        if (stack.isValid() && !FUEL_MAP.contains(stack)) {
            FUEL_MAP.add(stack);
        }
    }

    private static boolean mapContains(SimpleStack stack) {
        return stack.isValid() && FUEL_MAP.contains(stack);
    }

    public static void refreshFuelsJEI() {
        for (FuelUpgradeRecipe recipe : jeiRecipeList) {
            PEJeiPlugin.RUNTIME.getRecipeRegistry().removeRecipe((IRecipeWrapper)recipe, "pe.collector");
        }
        jeiRecipeList.clear();
        for (SimpleStack stack : FUEL_MAP) {
            if (EMCHelper.getEmcValue(stack.toItemStack()) > EMCHelper.getEmcValue(FuelMapper.getFuelUpgrade(stack.toItemStack()))) continue;
            FuelUpgradeRecipe recipe = new FuelUpgradeRecipe(stack.toItemStack(), FuelMapper.getFuelUpgrade(stack.toItemStack()));
            jeiRecipeList.add(recipe);
            PEJeiPlugin.RUNTIME.getRecipeRegistry().addRecipe((IRecipeWrapper)recipe, "pe.collector");
        }
    }
}

