/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageMap;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageType;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;

public class SimpleDefaultMessageMap
implements DefaultMessageMap {
    protected final Map<DefaultMessageType, String> defaults = new EnumMap<DefaultMessageType, String>(DefaultMessageType.class);

    public SimpleDefaultMessageMap(@Nullable String defaultString) {
        for (DefaultMessageType defaultMessageType : DefaultMessageType.values()) {
            this.defaults.put(defaultMessageType, defaultString);
        }
    }

    public SimpleDefaultMessageMap() {
    }

    @Override
    @Nonnull
    public SimpleDefaultMessageMap setDefault(@Nonnull DefaultMessageType key, @Nullable String defaultString) {
        this.defaults.put(Sanity.nullCheck(key, "Key cannot be null"), defaultString);
        return this;
    }

    @Override
    @Nonnull
    public Optional<String> getDefault(DefaultMessageType key) {
        return this.getDefault(Sanity.nullCheck(key, "Key cannot be null"), key.getFallback());
    }

    @Override
    @Nonnull
    public Optional<String> getDefault(@Nonnull DefaultMessageType key, @Nullable String defaultValue) {
        Sanity.nullCheck(key, "Key cannot be null");
        return Optional.ofNullable(this.defaults.getOrDefault((Object)key, defaultValue));
    }

    @Override
    @Nonnull
    public Map<DefaultMessageType, String> getDefaults() {
        return Collections.unmodifiableMap(new EnumMap<DefaultMessageType, String>(this.defaults));
    }
}

