/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientConnectionClosedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientConnectionEstablishedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientConnectionFailedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehConnectionException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehNagException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehStsException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageType;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsClientState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsMachine;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsPolicy;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.AcceptingTrustManagerFactory;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class NettyManager {
    @Nullable
    private static Bootstrap bootstrap;
    @Nullable
    private static EventLoopGroup eventLoopGroup;
    private static final Set<Client.WithManagement> clients;

    private NettyManager() {
    }

    private static synchronized void removeClientConnection(@Nonnull Client.WithManagement client) {
        clients.remove(client);
        if (clients.isEmpty()) {
            if (eventLoopGroup != null) {
                eventLoopGroup.shutdownGracefully();
            }
            eventLoopGroup = null;
            bootstrap = null;
        }
    }

    public static synchronized ClientConnection connect(@Nonnull Client.WithManagement client) {
        if (client.getStsMachine().isPresent() && !client.isSecureConnection()) {
            String hostname = client.getServerAddress().getHostName();
            StsMachine machine = client.getStsMachine().get();
            if (machine.getStorageManager().hasEntry(hostname)) {
                StsPolicy policy = machine.getStorageManager().getEntry(hostname).get();
                machine.setStsPolicy(policy);
                machine.setCurrentState(StsClientState.STS_POLICY_CACHED);
            }
        }
        if (bootstrap == null) {
            bootstrap = new Bootstrap();
            bootstrap.channel(NioSocketChannel.class);
            bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel channel) {
                }
            });
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true);
            eventLoopGroup = new NioEventLoopGroup();
            bootstrap.group(eventLoopGroup);
        }
        InetSocketAddress bind = client.getBindAddress();
        InetSocketAddress server = client.getServerAddress();
        ClientConnection clientConnection = new ClientConnection(client, bootstrap.connect((SocketAddress)server, (SocketAddress)bind));
        clients.add(client);
        return clientConnection;
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).toString();
    }

    static {
        clients = new HashSet<Client.WithManagement>();
    }

    public static final class ClientConnection {
        private static final int MAX_LINE_LENGTH = 4096;
        private final Client.WithManagement client;
        private final Channel channel;
        private boolean reconnect = true;
        @Nullable
        private volatile ChannelFuture channelFuture;
        @Nullable
        private ScheduledFuture<?> ping;
        private volatile String lastMessage;
        private boolean alive = true;

        private ClientConnection(@Nonnull Client.WithManagement client, @Nonnull ChannelFuture channelFuture) {
            this.client = client;
            this.channel = channelFuture.channel();
            this.channelFuture = channelFuture;
            channelFuture.addListener(future -> {
                this.channelFuture = null;
                if (future.isSuccess()) {
                    this.buildOurFutureTogether();
                    this.client.getEventManager().callEvent(new ClientConnectionEstablishedEvent(this.client));
                    this.client.beginMessageSendingImmediate(arg_0 -> ((Channel)this.channel).writeAndFlush(arg_0));
                } else {
                    this.alive = false;
                    ClientConnectionFailedEvent event = new ClientConnectionFailedEvent(this.client, this.reconnect, future.cause());
                    this.client.getEventManager().callEvent(event);
                    this.client.getExceptionListener().queue(new KittehConnectionException(future.cause(), false));
                    if (event.willAttemptReconnect()) {
                        this.scheduleReconnect(event.getReconnectionDelay());
                    }
                }
            });
        }

        private void buildOurFutureTogether() {
            this.channel.pipeline().addFirst("[OUTPUT] Output listener", (ChannelHandler)new MessageToMessageEncoder<String>(){

                protected void encode(ChannelHandlerContext ctx, String msg, List<Object> out) {
                    client.getOutputListener().queue(msg);
                    out.add(msg);
                }
            });
            this.channel.pipeline().addFirst("[OUTPUT] Add line breaks", (ChannelHandler)new MessageToMessageEncoder<String>(){

                protected void encode(ChannelHandlerContext ctx, String msg, List<Object> out) {
                    out.add(msg + "\r\n");
                }
            });
            this.channel.pipeline().addFirst("[OUTPUT] String encoder", (ChannelHandler)new StringEncoder(CharsetUtil.UTF_8));
            this.channel.pipeline().addLast("[INPUT] Idle state handler", (ChannelHandler)new IdleStateHandler(250, 0, 0));
            this.channel.pipeline().addLast("[INPUT] Catch idle", (ChannelHandler)new ChannelDuplexHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                    IdleStateEvent e;
                    if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.READER_IDLE && e.isFirst()) {
                        this.shutdown(DefaultMessageType.QUIT_PING_TIMEOUT, true);
                    }
                }
            });
            this.channel.pipeline().addLast("[INPUT] Line splitter", (ChannelHandler)new DelimiterBasedFrameDecoder(4096, Unpooled.wrappedBuffer((byte[])new byte[]{13, 10})));
            this.channel.pipeline().addLast("[INPUT] String decoder", (ChannelHandler)new StringDecoder(CharsetUtil.UTF_8));
            this.channel.pipeline().addLast("[INPUT] Send to client", (ChannelHandler)new SimpleChannelInboundHandler<String>(){

                protected void channelRead0(ChannelHandlerContext ctx, String msg) {
                    if (msg == null) {
                        return;
                    }
                    client.getInputListener().queue(msg);
                    client.processLine(msg);
                    lastMessage = msg;
                }
            });
            if (this.client.isSecureConnection()) {
                try {
                    Path keyCertChain = this.client.getSecureKeyCertChain();
                    File keyCertChainFile = keyCertChain == null ? null : keyCertChain.toFile();
                    Path key = this.client.getSecureKey();
                    File keyFile = key == null ? null : key.toFile();
                    String keyPassword = this.client.getSecureKeyPassword();
                    TrustManagerFactory factory = this.client.getSecureTrustManagerFactory();
                    if (factory == null) {
                        factory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                        factory.init((KeyStore)null);
                    } else if (AcceptingTrustManagerFactory.isInsecure(factory)) {
                        this.client.getExceptionListener().queue(new KittehNagException(String.format("Client '%s' is using an insecure trust manager factory.", this.client)));
                    }
                    SslContext sslContext = SslContextBuilder.forClient().trustManager(factory).keyManager(keyCertChainFile, keyFile, keyPassword).build();
                    InetSocketAddress addr = this.client.getServerAddress();
                    SslHandler sslHandler = sslContext.newHandler(this.channel.alloc(), addr.getHostString(), addr.getPort());
                    sslHandler.handshakeFuture().addListener(handshakeFuture -> {
                        StsMachine machine;
                        if (!handshakeFuture.isSuccess() && this.client.getStsMachine().isPresent() && (machine = this.client.getStsMachine().get()).getCurrentState() == StsClientState.STS_PRESENT_RECONNECTING) {
                            this.shutdown(DefaultMessageType.STS_FAILURE, false);
                            machine.setCurrentState(StsClientState.STS_PRESENT_CANNOT_CONNECT);
                            throw new KittehStsException("Handshake failure, aborting STS-protected connection attempt.", handshakeFuture.cause());
                        }
                    });
                    this.channel.pipeline().addFirst(new ChannelHandler[]{sslHandler});
                }
                catch (KeyStoreException | NoSuchAlgorithmException | SSLException e) {
                    this.client.getExceptionListener().queue(new KittehConnectionException(e, true));
                    return;
                }
            }
            this.channel.pipeline().addLast("[INPUT] Exception handler", (ChannelHandler)new ChannelInboundHandlerAdapter(){

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                    if (cause instanceof Exception) {
                        this.handleException((Exception)cause);
                    }
                }
            });
            this.channel.pipeline().addFirst("[OUTPUT] Exception handler", (ChannelHandler)new ChannelOutboundHandlerAdapter(){

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                    if (cause instanceof Exception) {
                        this.handleException((Exception)cause);
                    }
                }
            });
            this.channel.closeFuture().addListener(future -> {
                if (this.ping != null) {
                    this.ping.cancel(true);
                }
                this.alive = false;
                ClientConnectionClosedEvent event = new ClientConnectionClosedEvent(this.client, this.reconnect, future.cause(), this.lastMessage);
                this.client.getEventManager().callEvent(event);
                if (event.willAttemptReconnect()) {
                    this.scheduleReconnect(event.getReconnectionDelay());
                }
            });
        }

        private void scheduleReconnect(int delay) {
            this.channel.eventLoop().schedule(this.client::connect, (long)delay, TimeUnit.MILLISECONDS);
        }

        private void handleException(Exception thrown) {
            this.client.getExceptionListener().queue(thrown);
            if (thrown instanceof IOException) {
                this.shutdown(DefaultMessageType.QUIT_INTERNAL_EXCEPTION, true);
            }
        }

        public boolean isAlive() {
            return this.alive;
        }

        public void startPing() {
            this.ping = this.channel.eventLoop().scheduleWithFixedDelay(this.client::ping, 60L, 60L, TimeUnit.SECONDS);
        }

        public void shutdown(DefaultMessageType messageType, boolean reconnect) {
            this.shutdown((String)this.client.getDefaultMessageMap().getDefault(messageType).orElse(null), reconnect);
        }

        public void shutdown(@Nullable String message, boolean reconnect) {
            this.reconnect = reconnect;
            this.client.pauseMessageSending();
            this.channel.writeAndFlush((Object)("QUIT" + (message != null ? " :" + message : "")));
            this.channel.close();
            ChannelFuture future = this.channelFuture;
            if (future != null) {
                future.cancel(true);
                NettyManager.removeClientConnection(this.client);
            }
            if (!reconnect) {
                NettyManager.removeClientConnection(this.client);
            }
        }

        @Nonnull
        public String toString() {
            return new ToStringer(this).add("client", this.client).toString();
        }
    }
}

