/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.util;

import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.StackInfo;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemInfo
implements StackInfo {
    public static final ItemInfo EMPTY = new ItemInfo(ItemStack.field_190927_a);
    @Nonnull
    private Item item;
    private int meta = 0;
    private boolean isWildcard = false;

    public ItemInfo(@Nonnull Item item) {
        this.item = item;
        this.checkWildcard();
    }

    public ItemInfo(@Nonnull Item item, int meta) {
        this.item = item;
        if (meta == -1 || meta == Short.MAX_VALUE) {
            this.isWildcard = true;
        } else {
            this.meta = meta;
            this.checkWildcard();
        }
    }

    public ItemInfo(@Nonnull ItemStack stack) {
        this.item = stack.func_77973_b();
        this.meta = stack.func_77952_i();
        this.checkWildcard();
    }

    public ItemInfo(@Nonnull Block block) {
        this.item = Item.func_150898_a((Block)block);
        this.checkWildcard();
    }

    public ItemInfo(@Nonnull Block block, int blockMeta) {
        this.item = Item.func_150898_a((Block)block);
        if (this.item == Items.field_190931_a) {
            this.isWildcard = true;
        } else if (blockMeta == -1 || blockMeta == Short.MAX_VALUE) {
            this.isWildcard = true;
        } else {
            this.meta = blockMeta;
            this.checkWildcard();
        }
    }

    public ItemInfo(@Nonnull String string) {
        if (string.isEmpty() || string.length() < 2) {
            this.item = Items.field_190931_a;
            this.isWildcard = true;
            return;
        }
        String[] split = string.split(":");
        Item item = null;
        int meta = 0;
        switch (split.length) {
            case 1: {
                item = Item.func_111206_d((String)("minecraft:" + split[0]));
                break;
            }
            case 2: {
                try {
                    meta = split[1].equals("*") ? -1 : Integer.parseInt(split[1]);
                    item = Item.func_111206_d((String)("minecraft:" + split[0]));
                }
                catch (NumberFormatException e) {
                    this.isWildcard = true;
                    meta = 0;
                    item = Item.func_111206_d((String)(split[0] + ":" + split[1]));
                }
                break;
            }
            case 3: {
                try {
                    meta = split[2].equals("*") ? -1 : Integer.parseInt(split[2]);
                    item = Item.func_111206_d((String)(split[0] + ":" + split[1]));
                }
                catch (NumberFormatException e) {
                    meta = 0;
                    this.isWildcard = true;
                }
                break;
            }
            default: {
                this.item = Items.field_190931_a;
                this.isWildcard = true;
                return;
            }
        }
        if (item == null) {
            this.item = Items.field_190931_a;
            this.isWildcard = true;
        } else {
            this.item = item;
            if (meta == -1 || meta == Short.MAX_VALUE) {
                this.isWildcard = true;
            } else {
                this.meta = meta;
                this.checkWildcard();
            }
        }
    }

    public ItemInfo(@Nonnull IBlockState state) {
        this.item = Item.func_150898_a((Block)state.func_177230_c());
        this.meta = state.func_177230_c().func_176201_c(state);
    }

    public static ItemInfo readFromNBT(NBTTagCompound tag) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(tag.func_74779_i("item")));
        int meta = tag.func_74762_e("meta");
        return item == null ? EMPTY : new ItemInfo(item, meta);
    }

    private void checkWildcard() {
        NonNullList subItems = NonNullList.func_191196_a();
        this.item.func_150895_a(this.item.func_77640_w(), subItems);
        if (subItems.size() <= 1) {
            this.isWildcard = true;
        }
    }

    @Override
    public String toString() {
        return ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item) + (this.meta == 0 ? "" : ":" + this.meta);
    }

    @Override
    @Nonnull
    public ItemStack getItemStack() {
        return this.item == Items.field_190931_a ? ItemStack.field_190927_a : new ItemStack(this.item, 1, this.meta);
    }

    @Override
    public boolean hasBlock() {
        return this.item instanceof ItemBlock;
    }

    @Override
    @Nonnull
    public Block getBlock() {
        return Block.func_149634_a((Item)this.item);
    }

    @Override
    @Nonnull
    public IBlockState getBlockState() {
        if (this.item == Items.field_190931_a) {
            return Blocks.field_150350_a.func_176223_P();
        }
        try {
            return Block.func_149634_a((Item)this.item).func_176203_a(this.meta);
        }
        catch (Exception e) {
            return Block.func_149634_a((Item)this.item).func_176223_P();
        }
    }

    @Override
    public int getMeta() {
        return this.isWildcard ? -1 : this.meta;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("item", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item) == null ? "" : ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)this.item).toString());
        tag.func_74768_a("meta", this.meta);
        return tag;
    }

    @Override
    public boolean isValid() {
        return this.item != Items.field_190931_a && this.meta <= Short.MAX_VALUE;
    }

    @Override
    public int hashCode() {
        return this.item.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this.isWildcard) {
            if (obj instanceof ItemInfo) {
                return ItemStack.func_185132_d((ItemStack)((ItemInfo)obj).getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof ItemStack) {
                return ItemStack.func_185132_d((ItemStack)((ItemStack)obj), (ItemStack)this.getItemStack());
            }
            if (obj instanceof BlockInfo) {
                return ItemStack.func_185132_d((ItemStack)((BlockInfo)obj).getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof Block) {
                BlockInfo block = new BlockInfo((Block)obj);
                return ItemStack.func_185132_d((ItemStack)block.getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof Item) {
                ItemInfo item = new ItemInfo((Item)obj);
                return ItemStack.func_185132_d((ItemStack)item.getItemStack(), (ItemStack)this.getItemStack());
            }
        } else {
            if (obj instanceof ItemInfo) {
                return ItemStack.func_77989_b((ItemStack)((ItemInfo)obj).getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof ItemStack) {
                return ItemStack.func_77989_b((ItemStack)((ItemStack)obj), (ItemStack)this.getItemStack());
            }
            if (obj instanceof BlockInfo) {
                return ItemStack.func_77989_b((ItemStack)((BlockInfo)obj).getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof Block) {
                BlockInfo block = new BlockInfo((Block)obj);
                return ItemStack.func_77989_b((ItemStack)block.getItemStack(), (ItemStack)this.getItemStack());
            }
            if (obj instanceof Item) {
                ItemInfo item = new ItemInfo((Item)obj);
                return ItemStack.func_77989_b((ItemStack)item.getItemStack(), (ItemStack)this.getItemStack());
            }
        }
        return false;
    }

    @Nonnull
    public Item getItem() {
        return this.item;
    }

    public boolean isWildcard() {
        return this.isWildcard;
    }
}

