/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries.prefab;

import com.google.gson.Gson;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.registries.manager.IDefaultRecipeProvider;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;

public abstract class BaseRegistry<RegType> {
    protected final Gson gson;
    private final List<? extends IDefaultRecipeProvider> defaultRecipeProviders;
    protected boolean hasAlreadyBeenLoaded = false;
    protected RegType registry;
    protected Type typeOfSource;

    public BaseRegistry(Gson gson, RegType registry, Type typeOfSource, @Nonnull List<? extends IDefaultRecipeProvider> defaultRecipeProviders) {
        this.gson = gson;
        this.registry = registry;
        this.typeOfSource = typeOfSource;
        this.defaultRecipeProviders = defaultRecipeProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveJson(File file) {
        FileWriter fw;
        block5: {
            fw = null;
            try {
                fw = new FileWriter(file);
                if (this.typeOfSource != null) {
                    this.gson.toJson(this.registry, this.typeOfSource, (Appendable)fw);
                    break block5;
                }
                this.gson.toJson(this.registry, (Appendable)fw);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fw);
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)fw);
            }
        }
        IOUtils.closeQuietly((Writer)fw);
    }

    public void loadJson(File file) {
        if (this.hasAlreadyBeenLoaded) {
            this.clearRegistry();
        }
        if (file.exists() && ModConfig.misc.enableJSONLoading) {
            try {
                FileReader fr = new FileReader(file);
                this.registerEntriesFromJSON(fr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.registerDefaults();
            if (ModConfig.misc.enableJSONLoading) {
                this.saveJson(file);
            }
        }
        this.hasAlreadyBeenLoaded = true;
    }

    protected abstract void registerEntriesFromJSON(FileReader var1);

    public void registerDefaults() {
        this.defaultRecipeProviders.forEach(recipeProvider -> recipeProvider.registerRecipeDefaults(this));
    }

    public abstract List<?> getRecipeList();

    public abstract void clearRegistry();

    public RegType getRegistry() {
        return this.registry;
    }

    public Type getTypeOfSource() {
        return this.typeOfSource;
    }
}

