/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.compatibility.jei.barrel.fluidblocktransform.FluidBlockTransformRecipe;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomEntityInfoJson;
import exnihilocreatio.json.CustomFluidBlockTransformerJson;
import exnihilocreatio.json.CustomIngredientJson;
import exnihilocreatio.json.CustomItemInfoJson;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryList;
import exnihilocreatio.registries.types.FluidBlockTransformer;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.EntityInfo;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.LogUtil;
import exnihilocreatio.util.StackInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidBlockTransformerRegistry
extends BaseRegistryList<FluidBlockTransformer> {
    public FluidBlockTransformerRegistry() {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(ItemInfo.class, (Object)new CustomItemInfoJson()).registerTypeAdapter(StackInfo.class, (Object)new CustomItemInfoJson()).registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).registerTypeAdapter(Ingredient.class, (Object)new CustomIngredientJson()).registerTypeAdapter(OreIngredientStoring.class, (Object)new CustomIngredientJson()).registerTypeAdapter(EntityInfo.class, (Object)new CustomEntityInfoJson()).registerTypeAdapter(FluidBlockTransformer.class, (Object)new CustomFluidBlockTransformerJson()).create(), ExNihiloRegistryManager.FLUID_BLOCK_DEFAULT_REGISTRY_PROVIDERS);
    }

    public void register(Fluid fluid, StackInfo inputBlock, StackInfo outputBlock) {
        this.register(fluid, inputBlock, outputBlock, null);
    }

    public void register(Fluid fluid, StackInfo inputBlock, StackInfo outputBlock, String entityName) {
        if (fluid == null) {
            LogUtil.error("Fluid is null, this may not happen!");
            for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
                LogUtil.warn(stackTraceElement);
            }
            return;
        }
        this.register(fluid.getName(), Ingredient.func_193369_a((ItemStack[])new ItemStack[]{inputBlock.getItemStack()}), outputBlock, entityName, entityName == null ? 0 : 4, entityName == null ? 0 : 4);
    }

    public void register(Fluid fluid, String oredict, StackInfo outputBlock) {
        this.register(fluid, oredict, outputBlock, null);
    }

    public void register(Fluid fluid, String oredict, StackInfo outputBlock, String entityName) {
        this.register(fluid.getName(), (Ingredient)new OreIngredientStoring(oredict), outputBlock, entityName, entityName == null ? 0 : 4, entityName == null ? 0 : 4);
    }

    public void register(@Nonnull String fluid, @Nonnull Ingredient input, @Nonnull StackInfo outputBlock, @Nullable String entityName, int spawnCount, int spawnRange) {
        if (outputBlock.hasBlock()) {
            this.register(new FluidBlockTransformer(fluid, input, new BlockInfo(outputBlock.getBlockState()), entityName, spawnCount, spawnRange));
        } else {
            LogUtil.error("Item " + outputBlock.toString() + "  has no block version!");
        }
    }

    public boolean canBlockBeTransformedWithThisFluid(Fluid fluid, ItemStack stack) {
        for (FluidBlockTransformer transformer : (List)this.registry) {
            if (!fluid.getName().equals(transformer.getFluidName()) || !transformer.getInput().apply(stack)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public BlockInfo getBlockForTransformation(Fluid fluid, ItemStack stack) {
        for (FluidBlockTransformer transformer : (List)this.registry) {
            if (!fluid.getName().equals(transformer.getFluidName()) || !transformer.getInput().apply(stack)) continue;
            return transformer.getOutput();
        }
        return BlockInfo.EMPTY;
    }

    public int getSpawnCountForTransformation(Fluid fluid, ItemStack stack) {
        for (FluidBlockTransformer transformer : (List)this.registry) {
            if (!fluid.getName().equals(transformer.getFluidName()) || !transformer.getInput().apply(stack)) continue;
            return transformer.getSpawnCount();
        }
        return 0;
    }

    public int getSpawnRangeForTransformation(Fluid fluid, ItemStack stack) {
        for (FluidBlockTransformer transformer : (List)this.registry) {
            if (!fluid.getName().equals(transformer.getFluidName()) || !transformer.getInput().apply(stack)) continue;
            return transformer.getSpawnRange();
        }
        return 0;
    }

    public FluidBlockTransformer getTransformation(Fluid fluid, ItemStack stack) {
        for (FluidBlockTransformer transformer : (List)this.registry) {
            if (!fluid.getName().equals(transformer.getFluidName()) || !transformer.getInput().apply(stack)) continue;
            return transformer;
        }
        return null;
    }

    public EntityInfo getSpawnForTransformation(Fluid fluid, ItemStack stack) {
        for (FluidBlockTransformer transformer : (List)this.registry) {
            if (!fluid.getName().equals(transformer.getFluidName()) || !transformer.getInput().apply(stack)) continue;
            return transformer.getToSpawn();
        }
        return null;
    }

    @Override
    protected void registerEntriesFromJSON(FileReader fr) {
        List gsonInput = (List)this.gson.fromJson((Reader)fr, new TypeToken<List<FluidBlockTransformer>>(){}.getType());
        ((List)this.registry).addAll(gsonInput);
    }

    @Override
    public List<FluidBlockTransformRecipe> getRecipeList() {
        ArrayList<FluidBlockTransformRecipe> fluidBlockTransformRecipes = new ArrayList<FluidBlockTransformRecipe>();
        for (FluidBlockTransformer transformer : (List)this.registry) {
            FluidBlockTransformRecipe recipe;
            if (!FluidRegistry.isFluidRegistered((String)transformer.getFluidName()) || transformer.getInput().func_193365_a().length <= 0 || !transformer.getOutput().isValid() || !(recipe = new FluidBlockTransformRecipe(transformer)).isValid()) continue;
            fluidBlockTransformRecipes.add(recipe);
        }
        return fluidBlockTransformRecipes;
    }
}

