/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.compatibility.jei.crucible.CrucibleRecipe;
import exnihilocreatio.json.CustomBlockInfoJson;
import exnihilocreatio.json.CustomIngredientJson;
import exnihilocreatio.json.CustomMeltableJson;
import exnihilocreatio.registries.ingredient.IngredientUtil;
import exnihilocreatio.registries.ingredient.OreIngredientStoring;
import exnihilocreatio.registries.manager.IDefaultRecipeProvider;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import exnihilocreatio.registries.types.Meltable;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.LogUtil;
import exnihilocreatio.util.StackInfo;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;

public class CrucibleRegistry
extends BaseRegistryMap<Ingredient, Meltable> {
    public CrucibleRegistry(List<? extends IDefaultRecipeProvider> defaultRecipeProviders) {
        super(new GsonBuilder().setPrettyPrinting().registerTypeAdapter(BlockInfo.class, (Object)new CustomBlockInfoJson()).registerTypeAdapter(Ingredient.class, (Object)new CustomIngredientJson()).registerTypeAdapter(OreIngredientStoring.class, (Object)new CustomIngredientJson()).registerTypeAdapter(Meltable.class, (Object)new CustomMeltableJson()).enableComplexMapKeySerialization().create(), new TypeToken<Map<Ingredient, Meltable>>(){}.getType(), defaultRecipeProviders);
    }

    public void register(StackInfo item, Fluid fluid, int amount) {
        this.register(item.getItemStack(), fluid, amount);
    }

    @Override
    public void register(StackInfo item, Meltable meltable) {
        this.register(item.getItemStack(), meltable);
    }

    public void register(ItemStack stack, Fluid fluid, int amount) {
        this.register(stack, new Meltable(fluid.getName(), amount));
    }

    @Override
    public void register(ItemStack stack, Meltable meltable) {
        if (stack.func_190926_b() || !FluidRegistry.isFluidRegistered((String)meltable.getFluid())) {
            return;
        }
        if (((Map)this.registry).keySet().stream().anyMatch(ingredient -> ingredient.test((Object)stack))) {
            LogUtil.warn("Crucible entry for " + stack.func_82833_r() + " with meta " + stack.func_77960_j() + " already exists, skipping.");
        } else {
            this.register(CraftingHelper.getIngredient((Object)stack), meltable);
        }
    }

    public void register(String name, Fluid fluid, int amount) {
        this.register(name, new Meltable(fluid.getName(), amount));
    }

    @Override
    public void register(String name, Meltable meltable) {
        OreIngredientStoring ingredient = new OreIngredientStoring(name);
        if (!FluidRegistry.isFluidRegistered((String)meltable.getFluid())) {
            return;
        }
        if (((Map)this.registry).keySet().stream().anyMatch(arg_0 -> CrucibleRegistry.lambda$register$1((Ingredient)ingredient, arg_0))) {
            LogUtil.error("Crucible Ore Entry for " + name + " already exists, skipping.");
        } else {
            ((Map)this.registry).put(ingredient, meltable);
        }
    }

    public boolean canBeMelted(ItemStack stack) {
        return ((Map)this.registry).keySet().stream().anyMatch(entry -> entry.test((Object)stack));
    }

    public boolean canBeMelted(StackInfo info) {
        return this.canBeMelted(info.getItemStack());
    }

    @Nonnull
    public Meltable getMeltable(ItemStack stack) {
        Ingredient ingredient = ((Map)this.registry).keySet().stream().filter(entry -> entry.test((Object)stack)).findFirst().orElse(null);
        if (ingredient != null) {
            return (Meltable)((Map)this.registry).get(ingredient);
        }
        return Meltable.EMPTY;
    }

    @Nonnull
    public Meltable getMeltable(StackInfo info) {
        return this.getMeltable(info.getItemStack());
    }

    @Nonnull
    public Meltable getMeltable(Item item, int meta) {
        return this.getMeltable(new ItemStack(item, meta));
    }

    @Override
    protected void registerEntriesFromJSON(FileReader fr) {
        Map gsonInput = (Map)this.gson.fromJson((Reader)fr, new TypeToken<Map<String, Meltable>>(){}.getType());
        gsonInput.forEach((key, value) -> {
            Ingredient ingredient = IngredientUtil.parseFromString(key);
            if (((Map)this.registry).keySet().stream().anyMatch(entry -> IngredientUtil.ingredientEquals(ingredient, entry))) {
                LogUtil.error("Compost JSON Entry for " + Arrays.toString(ingredient.func_193365_a()) + " already exists, skipping.");
            }
            ((Map)this.registry).put(ingredient, value);
        });
    }

    @Override
    public Map<Ingredient, Meltable> getRegistry() {
        return (Map)this.registry;
    }

    @Override
    public List<CrucibleRecipe> getRecipeList() {
        LinkedList crucibleRecipes = Lists.newLinkedList();
        this.getRegistry().forEach((crucibleItem, meltable) -> {
            Fluid fluid = FluidRegistry.getFluid((String)meltable.getFluid());
            LinkedList meltables = Lists.newLinkedList();
            int crucibleCount = (int)Math.ceil(1000.0f / (float)meltable.getAmount());
            Stream.of(crucibleItem.func_193365_a()).forEach(stack -> {
                if (meltables.stream().noneMatch(arg_0 -> ((ItemStack)stack).func_77969_a(arg_0))) {
                    ItemStack copy = stack.func_77946_l();
                    copy.func_190920_e(crucibleCount);
                    meltables.add(copy);
                }
            });
            ItemStack fluidBucket = FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
            CrucibleRecipe recipe = crucibleRecipes.stream().filter(crucibleRecipe -> crucibleRecipe.getFluid().func_77969_a(fluidBucket) && crucibleRecipe.isNonFull()).findFirst().orElse(null);
            if (recipe == null) {
                recipe = new CrucibleRecipe(fluid, Lists.newLinkedList());
                crucibleRecipes.add(recipe);
            }
            for (ItemStack stack2 : meltables) {
                if (recipe.isNonFull()) {
                    recipe.getInputs().add(stack2);
                    continue;
                }
                recipe = new CrucibleRecipe(fluid, Lists.newLinkedList());
                recipe.getInputs().add(stack2);
                crucibleRecipes.add(recipe);
            }
        });
        return crucibleRecipes;
    }

    private static /* synthetic */ boolean lambda$register$1(Ingredient ingredient, Ingredient entry) {
        return IngredientUtil.ingredientEquals(entry, ingredient);
    }
}

