/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.registries.registries;

import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.registries.prefab.BaseRegistryMap;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class BarrelLiquidBlacklistRegistry
extends BaseRegistryMap<Integer, List<String>> {
    public BarrelLiquidBlacklistRegistry() {
        super(new GsonBuilder().setPrettyPrinting().create(), new TypeToken<Map<Integer, List<String>>>(){}.getType(), ExNihiloRegistryManager.BARREL_LIQUID_BLACKLIST_DEFAULT_REGISTRY_PROVIDERS);
    }

    public boolean isBlacklisted(int level, String fluid) {
        return level < 0 || ((Map)this.registry).getOrDefault(level, Collections.EMPTY_LIST).contains(fluid);
    }

    @Override
    public void register(int level, String fluid) {
        List list = ((Map)this.registry).computeIfAbsent(level, k -> new ArrayList());
        list.add(fluid);
    }

    @Override
    protected void registerEntriesFromJSON(FileReader fr) {
        Map loaded = (Map)this.gson.fromJson((Reader)fr, new com.google.common.reflect.TypeToken<Map<Integer, List<String>>>(){}.getType());
        loaded.forEach((integer, strings) -> {
            for (String string : strings) {
                this.register((int)integer, string);
            }
        });
    }

    @Override
    public List<?> getRecipeList() {
        return Lists.newLinkedList();
    }
}

