/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.json.JsonHelper;
import exnihilocreatio.registries.types.Meltable;
import exnihilocreatio.util.BlockInfo;
import java.lang.reflect.Type;

public class CustomMeltableJson
implements JsonDeserializer<Meltable>,
JsonSerializer<Meltable> {
    public JsonElement serialize(Meltable src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("fluid", src.getFluid());
        obj.addProperty("amount", (Number)src.getAmount());
        if (!src.getTextureOverride().equals(BlockInfo.EMPTY)) {
            obj.add("color", context.serialize((Object)src.getTextureOverride(), BlockInfo.class));
        }
        return obj;
    }

    public Meltable deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonHelper helper = new JsonHelper(json);
        JsonObject obj = json.getAsJsonObject();
        String fluid = helper.getString("fluid");
        int amount = helper.getInteger("amount");
        BlockInfo textureOverride = BlockInfo.EMPTY;
        if (obj.has("textureOverride")) {
            textureOverride = (BlockInfo)context.deserialize(json.getAsJsonObject().get("textureOverride"), BlockInfo.class);
        }
        return new Meltable(fluid, amount, textureOverride);
    }
}

