/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import exnihilocreatio.json.JsonHelper;
import exnihilocreatio.registries.types.HammerReward;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.LogUtil;
import java.lang.reflect.Type;
import net.minecraft.item.ItemStack;

public class CustomHammerRewardJson
implements JsonDeserializer<HammerReward>,
JsonSerializer<HammerReward> {
    public JsonElement serialize(HammerReward src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject obj = new JsonObject();
        obj.addProperty("item", src.getStack().func_77973_b().getRegistryName().toString() + ":" + src.getStack().func_77960_j());
        obj.addProperty("amount", (Number)src.getStack().func_190916_E());
        obj.addProperty("miningLevel", (Number)src.getMiningLevel());
        obj.addProperty("chance", (Number)Float.valueOf(src.getChance()));
        obj.addProperty("fortuneChance", (Number)Float.valueOf(src.getFortuneChance()));
        return obj;
    }

    public HammerReward deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        ItemStack stack;
        JsonHelper helper = new JsonHelper(json);
        JsonObject obj = json.getAsJsonObject();
        if (obj.has("item")) {
            ItemInfo info = new ItemInfo(helper.getString("item"));
            if (!info.isValid()) {
                LogUtil.error("Error parsing JSON: Invalid Item: " + json.toString());
                return new HammerReward(ItemStack.field_190927_a, 0, 0.0f, 0.0f);
            }
            stack = new ItemStack(info.getItem(), helper.getInteger("amount"), info.getMeta());
        } else {
            stack = (ItemStack)context.deserialize(json.getAsJsonObject().get("stack"), ItemStack.class);
        }
        int miningLevel = helper.getInteger("miningLevel");
        float chance = (float)helper.getDouble("chance");
        float fortuneChance = (float)helper.getDouble("fortuneChance");
        return new HammerReward(stack, miningLevel, chance, fortuneChance);
    }
}

