/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.items;

import exnihilocreatio.ExNihiloCreatio;
import exnihilocreatio.ModFluids;
import exnihilocreatio.util.Data;
import exnihilocreatio.util.IHasModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemDoll
extends Item
implements IHasModel {
    private static final Int2ObjectMap<DollType> existingTypes = new Int2ObjectArrayMap();

    public ItemDoll() {
        this.func_77655_b("item_doll");
        this.setRegistryName("item_doll");
        this.func_77637_a(ExNihiloCreatio.tabExNihilo);
        this.func_77627_a(true);
        existingTypes.put(DollType.BLAZE.meta, (Object)DollType.BLAZE);
        existingTypes.put(DollType.ENDERMAN.meta, (Object)DollType.ENDERMAN);
        existingTypes.put(DollType.SHULKER.meta, (Object)DollType.SHULKER);
        existingTypes.put(DollType.GUARDIAN.meta, (Object)DollType.GUARDIAN);
        if (Loader.isModLoaded((String)"thermalfoundation")) {
            existingTypes.put(DollType.BLIZZ.meta, (Object)DollType.BLIZZ);
            existingTypes.put(DollType.BLITZ.meta, (Object)DollType.BLITZ);
            existingTypes.put(DollType.BASALZ.meta, (Object)DollType.BASALZ);
        }
        if (Loader.isModLoaded((String)"tconstruct")) {
            existingTypes.put(DollType.BLUESLIME.meta, (Object)DollType.BLUESLIME);
        }
        Data.ITEMS.add(this);
    }

    public Fluid getSpawnFluid(ItemStack stack) {
        Fluid fluid = FluidRegistry.getFluid((String)((DollType)((Object)ItemDoll.existingTypes.get((int)stack.func_77960_j()))).fluidname);
        if (fluid != null) {
            return fluid;
        }
        return ModFluids.fluidWitchwater;
    }

    public boolean spawnMob(ItemStack stack, World world, BlockPos pos) {
        DollType type = (DollType)((Object)existingTypes.get(stack.func_77960_j()));
        if (type == null) {
            return false;
        }
        Entity spawnee = EntityList.func_188429_b((ResourceLocation)new ResourceLocation(type.entityname), (World)world);
        if (spawnee != null) {
            spawnee.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o() + type.posYCorrection, (double)pos.func_177952_p());
            return world.func_72838_d(spawnee);
        }
        return false;
    }

    @Nonnull
    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a() + "." + DollType.getByMeta((int)stack.func_77960_j()).name;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(@Nullable CreativeTabs tab, @Nonnull NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            for (DollType type : existingTypes.values()) {
                list.add((Object)new ItemStack((Item)this, 1, type.meta));
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel(ModelRegistryEvent event) {
        Int2ObjectArrayMap locations = new Int2ObjectArrayMap();
        for (DollType type : DollType.values()) {
            locations.put(type.meta, (Object)new ModelResourceLocation(this.getRegistryName(), "type=" + type.name));
        }
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])((ResourceLocation[])locations.values().toArray((Object[])new ModelResourceLocation[0])));
        ModelLoader.setCustomMeshDefinition((Item)this, arg_0 -> ItemDoll.lambda$initModel$0((Int2ObjectMap)locations, arg_0));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (existingTypes.containsKey(stack.func_77960_j())) {
            tooltip.add(I18n.func_135052_a((String)(this.func_77667_c(stack) + ".desc"), (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"debug.mod_not_installed.desc", (Object[])new Object[]{DollType.getByMeta((int)stack.func_77960_j()).modid}));
        }
    }

    private static /* synthetic */ ModelResourceLocation lambda$initModel$0(Int2ObjectMap locations, ItemStack stack) {
        return (ModelResourceLocation)locations.get(stack.func_77960_j());
    }

    public static enum DollType {
        BLAZE(0, "blaze", "minecraft", "minecraft:blaze", "lava", 1.0),
        ENDERMAN(1, "enderman", "minecraft", "minecraft:enderman", "witchwater", 2.0),
        SHULKER(2, "shulker", "minecraft", "minecraft:shulker", "witchwater", 1.5),
        GUARDIAN(3, "guardian", "minecraft", "minecraft:guardian", "water", 1.0),
        BLIZZ(4, "blizz", "thermalfoundation", "thermalfoundation:blizz", "pyrotheum", 1.0),
        BLITZ(5, "blitz", "thermalfoundation", "thermalfoundation:blitz", "pyrotheum", 1.0),
        BASALZ(6, "basalz", "thermalfoundation", "thermalfoundation:basalz", "pyrotheum", 1.0),
        BLUESLIME(7, "blueslime", "tconstruct", "tconstruct:blueslime", "milk", 2.0);

        private static final Int2ObjectMap<DollType> ALL_TYPES;
        public final int meta;
        public final String name;
        public final String modid;
        public final String entityname;
        public final String fluidname;
        public final double posYCorrection;

        private DollType(int meta, String name, String modid, String entityname, String fluidname, double posYCorrection) {
            this.meta = meta;
            this.name = name;
            this.modid = modid;
            this.entityname = entityname;
            this.fluidname = fluidname;
            this.posYCorrection = posYCorrection;
        }

        public static DollType getByMeta(int meta) {
            return (DollType)((Object)ALL_TYPES.get(meta));
        }

        static {
            ALL_TYPES = new Int2ObjectArrayMap();
            for (DollType dollType : DollType.values()) {
                ALL_TYPES.put(dollType.meta, (Object)dollType);
            }
        }
    }
}

