/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.sieve;

import com.google.common.collect.Lists;
import exnihilocreatio.ModItems;
import exnihilocreatio.blocks.BlockSieve;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.Siftable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;

public class SieveRecipe
implements IRecipeWrapper {
    private ItemStack mesh;
    private List<ItemStack> inputs = new ArrayList<ItemStack>();
    private List<ItemStack> outputs = new ArrayList<ItemStack>();

    public SieveRecipe(Ingredient ingredient, BlockSieve.MeshType mesh) {
        List<Siftable> rewards = ExNihiloRegistryManager.SIEVE_REGISTRY.getDrops(ingredient);
        if (rewards.isEmpty()) {
            return;
        }
        List allOutputs = rewards.stream().filter(reward -> reward.getMeshLevel() == mesh.getID()).map(reward -> reward.getDrop().getItemStack()).collect(Collectors.toList());
        this.mesh = new ItemStack((Item)ModItems.mesh, 1, mesh.getID());
        this.inputs = Arrays.asList(ingredient.func_193365_a());
        this.outputs = Lists.newArrayList();
        for (ItemStack stack : allOutputs) {
            boolean alreadyExists = false;
            for (ItemStack outputStack : this.outputs) {
                if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)outputStack)) continue;
                outputStack.func_190917_f(stack.func_190916_E());
                alreadyExists = true;
                break;
            }
            if (alreadyExists) continue;
            this.outputs.add(stack);
        }
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInput(ItemStack.class, this.inputs);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }

    public ItemStack getMesh() {
        return this.mesh;
    }

    public List getInputs() {
        return this.inputs;
    }

    public List getOutputs() {
        return this.outputs;
    }

    public boolean isValid() {
        return !this.inputs.isEmpty() && !this.outputs.isEmpty();
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
    }

    @Nonnull
    public List<String> getTooltipStrings(int mouseX, int mouseY) {
        return new ArrayList<String>();
    }

    public boolean handleClick(@Nonnull Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
        return false;
    }
}

