/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei;

import exnihilocreatio.ExNihiloCreatio;
import exnihilocreatio.ModBlocks;
import exnihilocreatio.ModItems;
import exnihilocreatio.compatibility.jei.barrel.compost.CompostRecipe;
import exnihilocreatio.compatibility.jei.barrel.compost.CompostRecipeCategory;
import exnihilocreatio.compatibility.jei.barrel.fluidblocktransform.FluidBlockTransformRecipe;
import exnihilocreatio.compatibility.jei.barrel.fluidblocktransform.FluidBlockTransformRecipeCategory;
import exnihilocreatio.compatibility.jei.barrel.fluidontop.FluidOnTopRecipe;
import exnihilocreatio.compatibility.jei.barrel.fluidontop.FluidOnTopRecipeCategory;
import exnihilocreatio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipe;
import exnihilocreatio.compatibility.jei.barrel.fluidtransform.FluidTransformRecipeCategory;
import exnihilocreatio.compatibility.jei.crucible.CrucibleHeatSourceRecipeCategory;
import exnihilocreatio.compatibility.jei.crucible.CrucibleRecipe;
import exnihilocreatio.compatibility.jei.crucible.CrucibleRecipeCategory;
import exnihilocreatio.compatibility.jei.crucible.HeatSourcesRecipe;
import exnihilocreatio.compatibility.jei.hammer.HammerRecipe;
import exnihilocreatio.compatibility.jei.hammer.HammerRecipeCategory;
import exnihilocreatio.compatibility.jei.sieve.SieveRecipe;
import exnihilocreatio.compatibility.jei.sieve.SieveRecipeCategory;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.util.LogUtil;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@JEIPlugin
public class CompatJEI
implements IModPlugin {
    public void registerItemSubtypes(@Nonnull ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(@Nonnull IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new SieveRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new HammerRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidOnTopRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidTransformRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new FluidBlockTransformRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CompostRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrucibleHeatSourceRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    @SideOnly(value=Side.CLIENT)
    public void register(@Nonnull IModRegistry registry) {
        LogUtil.info("ModConfig Loaded: " + ExNihiloCreatio.configsLoaded);
        if (!ExNihiloCreatio.configsLoaded) {
            ExNihiloCreatio.loadConfigs();
        }
        this.registerCompost(registry);
        this.registerFluidBlockTransform(registry);
        this.registerFluidOnTop(registry);
        this.registerFluidTransform(registry);
        this.registerHammer(registry);
        this.registerHeat(registry);
        this.registerSieve(registry);
        this.registerStoneCrucible(registry);
    }

    private void registerCompost(@Nonnull IModRegistry registry) {
        List<CompostRecipe> compostRecipes = ExNihiloRegistryManager.COMPOST_REGISTRY.getRecipeList();
        registry.addRecipes(compostRecipes, "exnihilocreatio:compost");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:compost"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:compost"});
        LogUtil.info("JEI: Compost Recipe Pages Loaded:         " + compostRecipes.size());
    }

    private void registerFluidBlockTransform(@Nonnull IModRegistry registry) {
        List<FluidBlockTransformRecipe> fluidBlockTransformRecipes = ExNihiloRegistryManager.FLUID_BLOCK_TRANSFORMER_REGISTRY.getRecipeList();
        registry.addRecipes(fluidBlockTransformRecipes, "exnihilocreatio:fluid_block_transform");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:fluid_block_transform"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:fluid_block_transform"});
        LogUtil.info("JEI: Fluid Block Transform Recipes Loaded:       " + fluidBlockTransformRecipes.size());
    }

    private void registerFluidOnTop(@Nonnull IModRegistry registry) {
        List<FluidOnTopRecipe> fluidOnTopRecipes = ExNihiloRegistryManager.FLUID_ON_TOP_REGISTRY.getRecipeList();
        registry.addRecipes(fluidOnTopRecipes, "exnihilocreatio:fluid_on_top");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:fluid_on_top"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:fluid_on_top"});
        LogUtil.info("JEI: Fluid On Top Recipes Loaded:       " + fluidOnTopRecipes.size());
    }

    private void registerFluidTransform(@Nonnull IModRegistry registry) {
        List<FluidTransformRecipe> fluidTransformRecipes = ExNihiloRegistryManager.FLUID_TRANSFORM_REGISTRY.getRecipeList();
        registry.addRecipes(fluidTransformRecipes, "exnihilocreatio:fluid_transform");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelWood), new String[]{"exnihilocreatio:fluid_transform"});
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.barrelStone), new String[]{"exnihilocreatio:fluid_transform"});
        LogUtil.info("JEI: Fluid Transform Recipes Loaded:    " + fluidTransformRecipes.size());
    }

    private void registerHammer(@Nonnull IModRegistry registry) {
        List<HammerRecipe> hammerRecipes = ExNihiloRegistryManager.HAMMER_REGISTRY.getRecipeList();
        registry.addRecipes(hammerRecipes, "exnihilocreatio:hammer");
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ModItems.hammerWood), new String[]{"exnihilocreatio:hammer"});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ModItems.hammerGold), new String[]{"exnihilocreatio:hammer"});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ModItems.hammerStone), new String[]{"exnihilocreatio:hammer"});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ModItems.hammerIron), new String[]{"exnihilocreatio:hammer"});
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ModItems.hammerDiamond), new String[]{"exnihilocreatio:hammer"});
        LogUtil.info("JEI: Hammer Recipes Loaded:             " + hammerRecipes.size());
    }

    private void registerHeat(@Nonnull IModRegistry registry) {
        List<HeatSourcesRecipe> heatSources = ExNihiloRegistryManager.HEAT_REGISTRY.getRecipeList();
        registry.addRecipes(heatSources, "exnihilocreatio:heat_sources");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.crucibleStone, 1, 1), new String[]{"exnihilocreatio:heat_sources"});
        LogUtil.info("JEI: Heat Sources Loaded:             " + heatSources.size());
    }

    private void registerSieve(@Nonnull IModRegistry registry) {
        List<SieveRecipe> sieveRecipes = ExNihiloRegistryManager.SIEVE_REGISTRY.getRecipeList();
        registry.addRecipes(sieveRecipes, "exnihilocreatio:sieve");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.sieve), new String[]{"exnihilocreatio:sieve"});
        LogUtil.info("JEI: Sieve Recipes Loaded:              " + sieveRecipes.size());
    }

    private void registerStoneCrucible(@Nonnull IModRegistry registry) {
        List<CrucibleRecipe> crucibleRecipes = ExNihiloRegistryManager.CRUCIBLE_STONE_REGISTRY.getRecipeList();
        registry.addRecipes(crucibleRecipes, "exnihilocreatio:crucible");
        registry.addRecipeCatalyst((Object)new ItemStack((Block)ModBlocks.crucibleStone, 1, 1), new String[]{"exnihilocreatio:crucible"});
        LogUtil.info("JEI: Stone Crucible Recipes Loaded:       " + crucibleRecipes.size());
    }

    public void onRuntimeAvailable(@Nonnull IJeiRuntime jeiRuntime) {
    }
}

