/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.crafttweaker;

import crafttweaker.api.item.IItemStack;
import exnihilocreatio.compatibility.crafttweaker.CrTIntegration;
import exnihilocreatio.compatibility.crafttweaker.prefab.ENCBaseAdd;
import exnihilocreatio.compatibility.crafttweaker.prefab.ENCBaseRemove;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.exnihilocreatio.Sieve")
public class Hammer {
    @ZenMethod
    public static void removeAll() {
        CrTIntegration.removeActions.add(new RemoveAll());
    }

    @ZenMethod
    public static void addRecipe(IItemStack block, IItemStack drop, int miningLevel, float chance, float fortuneChance) {
        CrTIntegration.addActions.add(new AddRecipe(block, drop, miningLevel, chance, fortuneChance));
    }

    private static class AddRecipe
    extends ENCBaseAdd {
        private final IBlockState state;
        private final IItemStack blockIn;
        private final IItemStack drop;
        private final int miningLevel;
        private final float chance;
        private final float fortuneChance;

        AddRecipe(IItemStack block, IItemStack drop, int miningLevel, float chance, float fortuneChance) {
            Block hammerBlock = Block.func_149634_a((Item)((ItemStack)block.getInternal()).func_77973_b());
            this.state = hammerBlock != Blocks.field_150350_a ? hammerBlock.func_176203_a(block.getMetadata()) : null;
            this.blockIn = block;
            this.miningLevel = miningLevel;
            this.fortuneChance = fortuneChance;
            this.drop = drop;
            this.chance = chance;
        }

        public void apply() {
            if (this.state == null) {
                return;
            }
            ExNihiloRegistryManager.HAMMER_REGISTRY.register(this.state, (ItemStack)this.drop.getInternal(), this.miningLevel, this.chance, this.fortuneChance);
        }

        public String describe() {
            if (this.state == null) {
                return "Can't add Hammer recipe for " + this.blockIn + " as it has no Block";
            }
            return "Adding Hammer recipe for " + this.state + " with drop " + this.drop + " at a chance of " + this.chance + " with mining level " + this.miningLevel;
        }
    }

    private static class RemoveAll
    extends ENCBaseRemove {
        private RemoveAll() {
        }

        public void apply() {
            ExNihiloRegistryManager.HAMMER_REGISTRY.clearRegistry();
        }

        public String describe() {
            return "Removing all recipes for the Ex Nihilo Hammer.";
        }
    }
}

