/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.barrel.modes.mobspawn;

import exnihilocreatio.barrel.IBarrelMode;
import exnihilocreatio.items.ItemDoll;
import exnihilocreatio.networking.MessageBarrelModeUpdate;
import exnihilocreatio.networking.PacketHandler;
import exnihilocreatio.texturing.Color;
import exnihilocreatio.tiles.TileBarrel;
import exnihilocreatio.util.Util;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemStackHandler;

public class BarrelModeMobSpawn
implements IBarrelMode {
    private float progress = 0.0f;
    private ItemStack dollStack;

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74776_a("progress", this.progress);
        NBTTagCompound dollTag = this.dollStack.func_77955_b(new NBTTagCompound());
        tag.func_74782_a("doll", (NBTBase)dollTag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.progress = tag.func_74760_g("progress");
        this.dollStack = new ItemStack((NBTTagCompound)tag.func_74781_a("doll"));
    }

    @Override
    public boolean isTriggerItemStack(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isTriggerFluidStack(FluidStack stack) {
        return false;
    }

    @Override
    public String getName() {
        return "mobspawn";
    }

    @Override
    public void onBlockActivated(World world, TileBarrel barrel, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTextureForRender(TileBarrel barrel) {
        if (this.dollStack == null) {
            return null;
        }
        ItemDoll doll = (ItemDoll)this.dollStack.func_77973_b();
        return Util.getTextureFromBlockState(doll.getSpawnFluid(this.dollStack).getBlock().func_176223_P());
    }

    @Override
    public Color getColorForRender() {
        return Util.whiteColor;
    }

    @Override
    public float getFilledLevelForRender(TileBarrel barrel) {
        return 0.9375f;
    }

    @Override
    public void update(TileBarrel barrel) {
        ItemDoll doll;
        boolean result;
        if (this.progress < 1.0f) {
            this.progress = (float)((double)this.progress + 0.0016666666666666668);
            PacketHandler.sendNBTUpdate(barrel);
        }
        if (this.progress >= 1.0f && (result = (doll = (ItemDoll)this.dollStack.func_77973_b()).spawnMob(this.dollStack, barrel.func_145831_w(), barrel.func_174877_v()))) {
            barrel.setMode("null");
            PacketHandler.sendToAllAround(new MessageBarrelModeUpdate("null", barrel.func_174877_v()), barrel);
        }
    }

    @Override
    public void addItem(ItemStack stack, TileBarrel barrel) {
    }

    @Override
    public ItemStackHandler getHandler(TileBarrel barrel) {
        return null;
    }

    @Override
    public FluidTank getFluidHandler(TileBarrel barrel) {
        return null;
    }

    @Override
    public boolean canFillWithFluid(TileBarrel barrel) {
        return false;
    }

    @Override
    public List<String> getWailaTooltip(TileBarrel barrel, List<String> currenttip) {
        currenttip.add("Spawning: " + Math.round(100.0f * this.progress) + "%");
        return currenttip;
    }

    public void setDollStack(ItemStack dollStack) {
        this.dollStack = dollStack;
    }
}

