/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.mech_mb;

import java.util.List;
import java.util.stream.Collectors;
import malte0811.industrialwires.blocks.converter.MechanicalMBBlockType;
import malte0811.industrialwires.mech_mb.Material;
import malte0811.industrialwires.mech_mb.MechEnergy;
import malte0811.industrialwires.mech_mb.MechMBPart;
import malte0811.industrialwires.util.LocalSidedWorld;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BakedQuadRetextured;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class MechPartFlywheel
extends MechMBPart {
    private static final double RADIUS = 1.25;
    private static final double THICKNESS = 1.0;
    private static final double VOLUME = 4.908738521234052;
    private Material material;

    public MechPartFlywheel() {
    }

    public MechPartFlywheel(Material m) {
        this.material = m;
    }

    @Override
    public void createMEnergy(MechEnergy e) {
    }

    @Override
    public double requestMEnergy(MechEnergy e) {
        return 0.0;
    }

    @Override
    public void insertMEnergy(double added) {
    }

    @Override
    public double getInertia() {
        return 0.5 * this.material.density * 4.908738521234052 * 1.25 * 1.25;
    }

    @Override
    public double getMaxSpeed() {
        return Math.sqrt(this.material.tensileStrength / this.material.density) / 1.25;
    }

    @Override
    public void writeToNBT(NBTTagCompound out) {
        out.func_74768_a("material", this.material.ordinal());
    }

    @Override
    public void readFromNBT(NBTTagCompound in) {
        this.material = Material.values()[in.func_74762_e("material")];
    }

    @Override
    public ResourceLocation getRotatingBaseModel() {
        return new ResourceLocation("industrialwires", "block/mech_mb/flywheel.obj");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getRotatingQuads() {
        List<BakedQuad> orig = super.getRotatingQuads();
        TextureAtlasSprite newTex = Minecraft.func_71410_x().func_147117_R().func_110572_b(this.material.blockTexture.toString());
        return orig.stream().map(quad -> {
            if (quad.func_187508_a().func_94215_i().contains("steel")) {
                return new BakedQuadRetextured(quad, newTex);
            }
            return quad;
        }).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canForm(LocalSidedWorld w) {
        BlockPos.PooledMutableBlockPos pos = BlockPos.PooledMutableBlockPos.func_185339_c((int)-1, (int)1, (int)0);
        try {
            this.material = null;
            for (Material m : Material.values()) {
                if (!m.matchesBlock(w, (BlockPos)pos, "block")) continue;
                this.material = m;
                break;
            }
            if (this.material == null) {
                boolean bl = false;
                return bl;
            }
            for (int x = -1; x <= 1; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    pos.func_181079_c(x, y, 0);
                    if (x == 0 && y == 0 || this.material.matchesBlock(w, (BlockPos)pos, "block")) continue;
                    int n = 0;
                    return n != 0;
                }
            }
            pos.func_181079_c(0, 0, 0);
            boolean bl = MechPartFlywheel.isValidDefaultCenter(w.getBlockState((BlockPos)pos));
            return bl;
        }
        finally {
            pos.func_185344_t();
        }
    }

    @Override
    public IBlockState getOriginalBlock(BlockPos pos) {
        if (pos.equals((Object)BlockPos.field_177992_a)) {
            return this.getDefaultShaft();
        }
        for (ItemStack block : OreDictionary.getOres((String)("block" + this.material.oreName()))) {
            if (!(block.func_77973_b() instanceof ItemBlock)) continue;
            ItemBlock ib = (ItemBlock)block.func_77973_b();
            return ib.func_179223_d().func_176203_a(block.func_77960_j());
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public void breakOnFailure(MechEnergy energy) {
        this.world.setBlockState(BlockPos.field_177992_a, this.getDefaultShaft());
        IBlockState state = Blocks.field_150350_a.func_176223_P();
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                if (x == 0 && y == 0) continue;
                this.world.setBlockState(new BlockPos(x, y, 0), state);
            }
        }
        this.spawnBrokenParts(8, energy, this.material.blockTexture);
    }

    @Override
    public short getFormPattern(int offset) {
        return 511;
    }

    @Override
    public MechanicalMBBlockType getType() {
        return MechanicalMBBlockType.FLYWHEEL;
    }

    @Override
    public AxisAlignedBB getBoundingBox(BlockPos offsetPart) {
        if (BlockPos.field_177992_a.equals((Object)offsetPart)) {
            return Block.field_185505_j;
        }
        double small = 0.375;
        double xMin = offsetPart.func_177958_n() <= 0 ? 0.0 : 0.375;
        double xMax = offsetPart.func_177958_n() >= 0 ? 1.0 : 0.625;
        double yMin = offsetPart.func_177956_o() >= 0 ? 0.0 : 0.375;
        double yMax = offsetPart.func_177956_o() <= 0 ? 1.0 : 0.625;
        return new AxisAlignedBB(xMin, yMin, 0.0625, xMax, yMax, 0.9375);
    }
}

