/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.hv;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.IngredientStack;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import malte0811.industrialwires.IndustrialWires;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class MarxOreHandler {
    private static final List<OreInfo> oreData = new ArrayList<OreInfo>();
    public static double defaultEnergy = 100000.0;
    public static double modifier;

    public static void preInit() {
        String[] ores;
        MarxOreHandler.putOre("oreIron", 0.5, 4.0, "dustIron", "nuggetIron");
        MarxOreHandler.putOre("oreGold", 1.0, 4.0, "dustGold", "nuggetGold");
        MarxOreHandler.putOre("oreDiamond", 2.0, 4.0, "gemDiamond");
        MarxOreHandler.putOre("oreEmerald", 2.25, 4.0, "gemEmerald");
        MarxOreHandler.putOre("oreLapis", 0.75, 10.0, "gemLapis");
        MarxOreHandler.putOre("oreCoal", 0.75, 8.0, Items.field_151044_h, 0);
        MarxOreHandler.putOre("oreRedstone", 1.0, 12.0, "dustRedstone");
        MarxOreHandler.putOre("oreQuartz", 1.0, 6.0, "gemQuartz");
        for (String ore : ores = new String[]{"Copper", "Aluminum", "Lead", "Silver", "Nickel", "Tin"}) {
            MarxOreHandler.putOre("ore" + ore, 0.75, 4.0, "dust" + ore, "nugget" + ore);
        }
        MarxOreHandler.putOre("oreUranium", 1.25, 4.0, IndustrialWires.hasIC2 ? "crushedUranium" : "dustUranium", "nuggetUranium");
    }

    public static void init() {
        oreData.removeIf(info -> info.exampleInput.isEmpty() || info.exampleInput.stream().allMatch(ItemStack::func_190926_b) || info.output.get().func_190926_b());
    }

    public static void putOre(String oreName, double avgEnergy, double maxYield, String oreOut) {
        MarxOreHandler.putOre(oreName, avgEnergy, maxYield, oreOut, null);
    }

    public static void putOre(String oreName, double avgEnergy, double maxYield, String oreOut, @Nullable String oreSmall) {
        MarxOreHandler.put(new OreInfo((BiPredicate<World, BlockPos>)new OreChecker(oreName), (List<ItemStack>)OreDictionary.getOres((String)oreName), avgEnergy, maxYield, oreOut, oreSmall));
    }

    public static void putOre(String oreName, double avgEnergy, double maxYield, Item oreOut, int meta) {
        MarxOreHandler.put(new OreInfo((BiPredicate<World, BlockPos>)new OreChecker(oreName), (List<ItemStack>)OreDictionary.getOres((String)oreName), avgEnergy, maxYield, oreOut, meta));
    }

    public static void put(OreInfo output) {
        oreData.add(output);
    }

    public static void resetModifier() {
        modifier = 0.9 + Utils.RAND.nextDouble() * 0.2;
    }

    public static ItemStack[] getYield(World world, BlockPos pos, double energy) {
        if (modifier < 0.89 || modifier > 1.11) {
            IndustrialWires.logger.error("The energy-modifier for Marx generators wasn't loaded correctly. It will be reset.");
            MarxOreHandler.resetModifier();
        }
        for (OreInfo ore : oreData) {
            int yield;
            int yieldNuggets;
            double idealE;
            if (!ore.isValid.test(world, pos) || !(energy >= 0.75 * (idealE = modifier * ore.avgEnergy * defaultEnergy))) continue;
            double sigma = idealE / 9.0;
            double dist = MarxOreHandler.getNormalizedNormalDist(energy, sigma, idealE);
            double out = dist * ore.maxYield;
            if ((yieldNuggets = (int)Math.round((out -= (double)(yield = (int)Math.floor(out))) * (double)ore.smallMax)) >= ore.smallMax || ore.outputSmall == null && (float)yieldNuggets >= (float)ore.smallMax / 2.0f) {
                ++yield;
                yieldNuggets = 0;
            }
            if (yield > 0 && yieldNuggets > 0 && ore.outputSmall != null) {
                return new ItemStack[]{ApiUtils.copyStackWithAmount((ItemStack)ore.output.get(), (int)yield), ApiUtils.copyStackWithAmount((ItemStack)ore.outputSmall.get(), (int)yieldNuggets)};
            }
            if (yield > 0) {
                return new ItemStack[]{ApiUtils.copyStackWithAmount((ItemStack)ore.output.get(), (int)yield)};
            }
            if (yieldNuggets <= 0 || ore.outputSmall == null) continue;
            return new ItemStack[]{ApiUtils.copyStackWithAmount((ItemStack)ore.outputSmall.get(), (int)yieldNuggets)};
        }
        return new ItemStack[0];
    }

    private static double getNormalizedNormalDist(double x, double sigma, double mu) {
        return Math.exp(-(x - mu) * (x - mu) / (2.0 * sigma * sigma));
    }

    public static List<OreInfo> getRecipes() {
        return oreData;
    }

    public static class OreChecker
    implements BiPredicate<World, BlockPos> {
        String oreName;

        public OreChecker(String ore) {
            this.oreName = ore;
        }

        @Override
        public boolean test(World world, BlockPos here) {
            int[] ores;
            IBlockState state = world.func_180495_p(here);
            ItemStack input = state.func_177230_c().getPickBlock(state, null, world, here, null);
            for (int id : ores = OreDictionary.getOreIDs((ItemStack)input)) {
                String name = OreDictionary.getOreName((int)id);
                if (!name.equals(this.oreName)) continue;
                return true;
            }
            return false;
        }
    }

    public static class OreInfo {
        public BiPredicate<World, BlockPos> isValid;
        public List<ItemStack> exampleInput;
        public final double avgEnergy;
        public final double maxYield;
        public final Supplier<ItemStack> output;
        @Nullable
        public final Supplier<ItemStack> outputSmall;
        public final int smallMax;

        public OreInfo(BiPredicate<World, BlockPos> isValid, List<ItemStack> exampleInput, double avg, double maxYield, Supplier<ItemStack> out, @Nullable Supplier<ItemStack> outSmall, int smallCount) {
            this.avgEnergy = avg;
            this.maxYield = maxYield;
            this.output = out;
            this.outputSmall = outSmall;
            this.smallMax = smallCount;
            this.isValid = isValid;
            this.exampleInput = exampleInput;
        }

        public OreInfo(BiPredicate<World, BlockPos> isValid, List<ItemStack> exampleInput, double avgEnergy, double maxYield, Item iOut, int mOut, @Nullable Item iOutSmall, int mOutSmall) {
            this.avgEnergy = avgEnergy;
            this.maxYield = maxYield;
            this.output = () -> ((IngredientStack)new IngredientStack(new ItemStack(iOut, 1, mOut))).getExampleStack();
            this.outputSmall = iOutSmall == null ? null : () -> ((IngredientStack)new IngredientStack(new ItemStack(iOutSmall, 1, mOutSmall))).getExampleStack();
            this.smallMax = 9;
            this.isValid = isValid;
            this.exampleInput = exampleInput;
        }

        public OreInfo(BiPredicate<World, BlockPos> isValid, List<ItemStack> exampleInput, double avgEnergy, double maxYield, Item iOut, int mOut) {
            this(isValid, exampleInput, avgEnergy, maxYield, iOut, mOut, null, 0);
        }

        public OreInfo(BiPredicate<World, BlockPos> isValid, List<ItemStack> exampleInput, double avgEnergy, double maxYield, String oreOut, @Nullable String oreSmall) {
            this.avgEnergy = avgEnergy;
            this.maxYield = maxYield;
            this.output = () -> ((IngredientStack)new IngredientStack(oreOut)).getExampleStack();
            this.outputSmall = oreSmall == null ? null : () -> ((IngredientStack)new IngredientStack(oreSmall)).getExampleStack();
            this.smallMax = 9;
            this.isValid = isValid;
            this.exampleInput = exampleInput;
        }

        public OreInfo(BiPredicate<World, BlockPos> isValid, List<ItemStack> exampleInput, double avgEnergy, double maxYield, String oreOut) {
            this(isValid, exampleInput, avgEnergy, maxYield, oreOut, null);
        }
    }
}

