/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.compat;

import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.IndustrialWires;
import malte0811.industrialwires.blocks.hv.BlockTypes_HVMultiblocks;
import malte0811.industrialwires.compat.Compat;
import malte0811.industrialwires.hv.MarxOreHandler;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class JEIMarx
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    private static MarxCategory marx;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        marx = new MarxCategory();
        registry.addRecipeCategories(new IRecipeCategory[]{marx});
    }

    public void register(IModRegistry registryIn) {
        registryIn.handleRecipes(MarxOreHandler.OreInfo.class, x$0 -> new MarxRecipeWrapper((MarxOreHandler.OreInfo)x$0), "industrialwires.marx");
        registryIn.addRecipes(MarxOreHandler.getRecipes(), "industrialwires.marx");
        registryIn.addRecipeCatalyst((Object)new ItemStack((Block)IndustrialWires.hvMultiblocks, 1, BlockTypes_HVMultiblocks.MARX.getMeta()), new String[]{marx.getUid()});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        Compat.addMarx = o -> jeiRuntime.getRecipeRegistry().addRecipe((IRecipeWrapper)new MarxRecipeWrapper((MarxOreHandler.OreInfo)o), marx.getUid());
        Compat.removeMarx = o -> jeiRuntime.getRecipeRegistry().removeRecipe((IRecipeWrapper)new MarxRecipeWrapper((MarxOreHandler.OreInfo)o), marx.getUid());
    }

    private class MarxRecipeWrapper
    implements IRecipeWrapper {
        MarxOreHandler.OreInfo recipe;

        public MarxRecipeWrapper(MarxOreHandler.OreInfo recipe) {
            this.recipe = recipe;
        }

        public void getIngredients(@Nonnull IIngredients ingredients) {
            ingredients.setInputLists(ItemStack.class, (List)ImmutableList.of(this.recipe.exampleInput));
            if (this.recipe.outputSmall != null) {
                ingredients.setOutputs(ItemStack.class, (List)ImmutableList.of((Object)this.recipe.output.get(), (Object)this.recipe.outputSmall.get()));
            } else {
                ingredients.setOutputs(ItemStack.class, (List)ImmutableList.of((Object)this.recipe.output.get(), (Object)ItemStack.field_190927_a));
            }
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
            IDrawableStatic slot = jeiHelpers.getGuiHelper().getSlotDrawable();
            slot.draw(minecraft, 10, 17);
            slot.draw(minecraft, 62, 4);
            if (this.recipe.outputSmall != null && !this.recipe.outputSmall.get().func_190926_b()) {
                slot.draw(minecraft, 62, 29);
                minecraft.field_71466_p.func_78276_b("x" + this.recipe.smallMax + I18n.func_135052_a((String)"industrialwires.desc.jei.alt", (Object[])new Object[0]), 85, 33, -16777216);
            }
            minecraft.field_71466_p.func_78276_b("x" + Utils.formatDouble((double)this.recipe.maxYield, (String)"0.#") + I18n.func_135052_a((String)"industrialwires.desc.jei.max", (Object[])new Object[0]), 85, 8, -16777216);
            minecraft.field_71466_p.func_78276_b("~", 0, 3, -16777216);
            minecraft.field_71466_p.func_78276_b((int)(this.recipe.avgEnergy * MarxOreHandler.defaultEnergy / 1000.0) + " kJ", minecraft.field_71466_p.func_78263_a('~'), 0, -16777216);
        }
    }

    private class MarxCategory
    implements IRecipeCategory<MarxRecipeWrapper> {
        private MarxCategory() {
        }

        @Nonnull
        public String getUid() {
            return "industrialwires.marx";
        }

        @Nonnull
        public String getTitle() {
            return I18n.func_135052_a((String)"industrialwires.desc.jei.marx", (Object[])new Object[0]);
        }

        @Nonnull
        public String getModName() {
            return "Industrial Wires";
        }

        @Nonnull
        public IDrawable getBackground() {
            IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
            return guiHelper.createBlankDrawable(140, 50);
        }

        public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull MarxRecipeWrapper recipeWrapper, @Nonnull IIngredients ingredients) {
            IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
            guiItemStacks.init(0, true, 10, 17);
            guiItemStacks.init(1, false, 62, 4);
            guiItemStacks.init(2, false, 62, 29);
            guiItemStacks.set(ingredients);
        }

        @Nullable
        public IDrawable getIcon() {
            return null;
        }
    }
}

