/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.client.render;

import malte0811.industrialwires.blocks.hv.TileEntityJacobsLadder;
import malte0811.industrialwires.client.render.Shaders;
import malte0811.industrialwires.util.Beziers;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;

public class TileRenderJacobsLadder
extends TileEntitySpecialRenderer<TileEntityJacobsLadder> {
    public void render(TileEntityJacobsLadder tile, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        super.func_192841_a((TileEntity)tile, x, y, z, partialTicks, destroyStage, alpha);
        if (!tile.isDummy() && tile.timeTillActive == 0 && tile.controls[0] != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + tile.size.heightOffset), (double)(z + 0.5));
            GlStateManager.func_179114_b((float)tile.facing.func_185119_l(), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179137_b((double)(-tile.size.bottomDistance / 2.0), (double)0.0, (double)0.0);
            GlStateManager.func_179090_x();
            GlStateManager.func_179140_f();
            GlStateManager.func_179103_j((int)7425);
            if (Shaders.areShadersEnabled()) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            this.func_190053_a(true);
            GlStateManager.func_179131_c((float)1.0f, (float)0.85f, (float)1.0f, (float)1.0f);
            Vec3d[] controls = new Vec3d[tile.size.arcPoints];
            for (int i = 0; i < tile.size.arcPoints; ++i) {
                Vec3d speed = tile.controlMovement[i].func_186678_a((double)partialTicks);
                controls[i] = tile.controls[i].func_178787_e(speed);
            }
            this.drawBezier(controls, tile.salt, tile.size);
            this.func_190053_a(false);
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179103_j((int)7424);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
    }

    private void drawBezier(Vec3d[] controls, double salt, TileEntityJacobsLadder.LadderSize size) {
        Shaders.useShader(Shaders.JACOBS_ARC);
        int steps = size.renderPoints;
        double diameter = size.renderDiameter;
        Vec3d radY = new Vec3d(0.0, diameter / 2.0, 0.0);
        Vec3d radZ = new Vec3d(0.0, 0.0, diameter / 2.0);
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vertBuffer = tes.func_178180_c();
        float[][] colors = new float[steps + 1][];
        vertBuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Vec3d last = Beziers.getPoint(0.0, controls);
        colors[0] = TileEntityJacobsLadder.getColor(0.0, salt, size);
        if (Shaders.areShadersEnabled()) {
            colors[0][0] = 0.0f;
        }
        for (int i = 1; i <= steps; ++i) {
            double d = (double)i / (double)steps;
            colors[i] = TileEntityJacobsLadder.getColor(d, salt, size);
            Vec3d pos = Beziers.getPoint(d, controls);
            if (Shaders.areShadersEnabled()) {
                colors[i][0] = (float)d;
            }
            this.drawQuad(last, pos, radY, colors[i - 1], colors[i], vertBuffer, false);
            this.drawQuad(last, pos, radZ, colors[i - 1], colors[i], vertBuffer, false);
            last = pos;
        }
        tes.func_78381_a();
        Shaders.stopUsingShaders();
    }

    private void drawQuad(Vec3d v0, Vec3d v1, Vec3d rad, float[] color0, float[] color1, BufferBuilder vertexBuffer, boolean horizontal) {
        float alpha0 = horizontal ? 0.5f : 0.0f;
        float alpha1 = horizontal ? 0.5f : 1.0f;
        this.color(color1, alpha0, vertexBuffer.func_181662_b(v1.field_72450_a - rad.field_72450_a, v1.field_72448_b - rad.field_72448_b, v1.field_72449_c - rad.field_72449_c)).func_181675_d();
        this.color(color0, alpha0, vertexBuffer.func_181662_b(v0.field_72450_a - rad.field_72450_a, v0.field_72448_b - rad.field_72448_b, v0.field_72449_c - rad.field_72449_c)).func_181675_d();
        this.color(color0, alpha1, vertexBuffer.func_181662_b(v0.field_72450_a + rad.field_72450_a, v0.field_72448_b + rad.field_72448_b, v0.field_72449_c + rad.field_72449_c)).func_181675_d();
        this.color(color1, alpha1, vertexBuffer.func_181662_b(v1.field_72450_a + rad.field_72450_a, v1.field_72448_b + rad.field_72448_b, v1.field_72449_c + rad.field_72449_c)).func_181675_d();
        this.color(color1, alpha1, vertexBuffer.func_181662_b(v1.field_72450_a + rad.field_72450_a, v1.field_72448_b + rad.field_72448_b, v1.field_72449_c + rad.field_72449_c)).func_181675_d();
        this.color(color0, alpha1, vertexBuffer.func_181662_b(v0.field_72450_a + rad.field_72450_a, v0.field_72448_b + rad.field_72448_b, v0.field_72449_c + rad.field_72449_c)).func_181675_d();
        this.color(color0, alpha0, vertexBuffer.func_181662_b(v0.field_72450_a - rad.field_72450_a, v0.field_72448_b - rad.field_72448_b, v0.field_72449_c - rad.field_72449_c)).func_181675_d();
        this.color(color1, alpha0, vertexBuffer.func_181662_b(v1.field_72450_a - rad.field_72450_a, v1.field_72448_b - rad.field_72448_b, v1.field_72449_c - rad.field_72449_c)).func_181675_d();
    }

    private BufferBuilder color(float[] color, float alpha, BufferBuilder vb) {
        vb.func_181666_a(color[0], color[1], color[2], alpha);
        return vb;
    }
}

