/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.mysticallib.tile.module;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class FaceConfig {
    private Map<EnumFacing, FaceIO> ioConfig = new EnumMap<EnumFacing, FaceIO>(EnumFacing.class);

    public FaceConfig(@Nonnull FaceIO defaultIO) {
        for (EnumFacing e : EnumFacing.values()) {
            this.ioConfig.put(e, defaultIO);
        }
    }

    @Nonnull
    public NBTTagCompound writeToNBT() {
        NBTTagCompound iotag = new NBTTagCompound();
        for (EnumFacing e : EnumFacing.values()) {
            iotag.func_74768_a(e.func_176610_l(), this.ioConfig.get(e).ordinal());
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("io", (NBTBase)iotag);
        return tag;
    }

    public void readFromNBT(@Nonnull NBTTagCompound tag) {
        NBTTagCompound iotag = tag.func_74775_l("io");
        for (EnumFacing e : EnumFacing.values()) {
            if (!iotag.func_74764_b(e.func_176610_l())) continue;
            this.ioConfig.put(e, FaceIO.values()[iotag.func_74762_e(e.func_176610_l())]);
        }
    }

    public void setIO(@Nonnull EnumFacing face, @Nonnull FaceIO io) {
        this.ioConfig.replace(face, io);
    }

    public void setAllIO(@Nonnull FaceIO io) {
        for (EnumFacing e : EnumFacing.values()) {
            this.setIO(e, io);
        }
    }

    @Nonnull
    public FaceIO getIO(@Nonnull EnumFacing dir) {
        return this.ioConfig.get(dir);
    }

    public static enum FaceIO {
        IN,
        OUT,
        NEUTRAL,
        INOUT,
        DISABLED;

    }
}

